/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.panels.resources.AbstractResourceInspector;
import org.pepstock.jem.gwt.client.panels.resources.inspector.NewResourceHeader;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourcesPropertiesPanel;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.custom.ResourceDescriptor;

public class NewResourceInspector
extends AbstractResourceInspector {
    private static int FIRST_CUSTOM_RESOURCE_INDEX = 6;
    private static final int LIST_HEIGHT = 40;
    private HorizontalPanel typePanel = new HorizontalPanel();
    private ListBox typeCombo = new ListBox();
    private Collection<String> customResourceNames = null;

    public NewResourceInspector() {
        super(new Resource());
        this.loadCustomResourceNames();
    }

    private void buildTypeCombo() {
        this.typePanel.setHeight(Sizes.toString(40));
        this.typeCombo.addStyleName(Styles.INSTANCE.common().bold());
        this.typeCombo.addItem("Select a Resource Type");
        this.typeCombo.addItem("JDBC");
        this.typeCombo.addItem("FTP");
        this.typeCombo.addItem("JMS");
        this.typeCombo.addItem("HTTP");
        this.typeCombo.addItem("JPPF");
        if (this.customResourceNames != null) {
            ArrayList<String> customResourceNameList = new ArrayList<String>(this.customResourceNames);
            Collections.sort(customResourceNameList);
            for (String type : customResourceNameList) {
                this.typeCombo.addItem(type);
            }
        }
        this.typePanel.add((Widget)this.typeCombo);
        this.typePanel.setCellVerticalAlignment((Widget)this.typeCombo, HasVerticalAlignment.ALIGN_MIDDLE);
        this.typePanel.setSpacing(6);
        this.mainContainer.add((Widget)this.typePanel);
        this.typeCombo.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int selectedIndex = NewResourceInspector.this.typeCombo.getSelectedIndex();
                if (selectedIndex > 0) {
                    NewResourceInspector.this.typeCombo.setEnabled(false);
                    String selectedResourceType = NewResourceInspector.this.typeCombo.getItemText(selectedIndex);
                    if (selectedIndex < FIRST_CUSTOM_RESOURCE_INDEX) {
                        ResourcesPropertiesPanel ootbPanel = NewResourceInspector.this.renderOOTBResourcePanel(selectedResourceType);
                        NewResourceInspector.this.showResourcePanel(ootbPanel);
                    } else {
                        Services.CUSTOM_RESOURCE_DEFINITIONS_MANAGER.getDescriptorOf(selectedResourceType, (AsyncCallback<ResourceDescriptor>)new ServiceAsyncCallback<ResourceDescriptor>(){

                            @Override
                            public void onJemFailure(Throwable caught) {
                                AlertMessageBox errorBox = new AlertMessageBox(2, "Custom Resource Definitions Error!", "Unable to load cutom resource definition: " + caught.getMessage());
                                errorBox.open();
                                NewResourceInspector.this.typeCombo.setEnabled(true);
                            }

                            @Override
                            public void onJemSuccess(ResourceDescriptor descriptor) {
                                ResourcesPropertiesPanel customPanel = NewResourceInspector.this.renderCustomResourcePanel(descriptor);
                                NewResourceInspector.this.showResourcePanel(customPanel);
                            }

                            @Override
                            public void onJemExecuted() {
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void showResourcePanel(ResourcesPropertiesPanel activePanel) {
        int availableWidth = this.getAvailableWidth();
        int availableHeight = this.getAvailableHeight() - 40;
        activePanel.initializeResource();
        this.mainContainer.add((Widget)this.resourcePanelContainer);
        this.resourcePanelContainer.setWidget((Widget)activePanel);
        this.resourcePanelContainer.setSize(Sizes.toString(availableWidth), Sizes.toString(availableHeight));
        activePanel.onResize(availableWidth, availableHeight);
    }

    private void loadCustomResourceNames() {
        Services.CUSTOM_RESOURCE_DEFINITIONS_MANAGER.getAllResourceNames((AsyncCallback<Collection<String>>)new ServiceAsyncCallback<Collection<String>>(){

            @Override
            public void onJemFailure(Throwable caught) {
                AlertMessageBox errorBox = new AlertMessageBox(2, "Custom Resource Definitions Error!", "Unable to load cutom resource definitions: " + caught.getMessage());
                errorBox.open();
                this.onSuccess(null);
            }

            @Override
            public void onJemSuccess(Collection<String> result) {
                NewResourceInspector.this.customResourceNames = result;
                NewResourceInspector.this.buildTypeCombo();
            }

            @Override
            public void onJemExecuted() {
            }
        });
    }

    @Override
    public void save() {
        if (this.checkMandatoryAttributes() && this.validate()) {
            if (this.getResource().getName() != null && !this.getResource().getName().trim().isEmpty()) {
                Services.COMMON_RESOURCES_MANAGER.addCommonResource(this.getResource(), (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Add resource command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        NewResourceInspector.this.hide();
                    }
                });
            } else {
                AlertMessageBox alert = new AlertMessageBox(2, "Invalid resource name!", "Please type a valid not-empty resource name");
                alert.open();
            }
        }
    }

    @Override
    public FlexTable getHeader() {
        return new NewResourceHeader(this.getResource(), this);
    }
}

