/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.Toast;
import org.pepstock.jem.gwt.client.panels.resources.AbstractResourceInspector;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourceHeader;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourcesPropertiesPanel;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.custom.ResourceDescriptor;

public class ExistingResourceInspector
extends AbstractResourceInspector {
    public ExistingResourceInspector(Resource resource) {
        super(resource);
        this.buildExistingPanel();
    }

    private void buildExistingPanel() {
        Class panelClass = (Class)RESOURCES_TYPES.get(this.getResource().getType().toUpperCase());
        if (panelClass != null) {
            try {
                ResourcesPropertiesPanel ootbPanel = this.renderOOTBResourcePanel(this.getResource().getType().toUpperCase());
                this.showResourcePanel(ootbPanel);
            }
            catch (Exception e) {
                Toast t = new Toast(2, "Cannot render custom resource panel!", "Rendering error");
                t.show();
            }
        } else {
            Services.CUSTOM_RESOURCE_DEFINITIONS_MANAGER.getDescriptorOf(this.getResource().getType(), (AsyncCallback<ResourceDescriptor>)new ServiceAsyncCallback<ResourceDescriptor>(){

                @Override
                public void onJemFailure(Throwable caught) {
                    AlertMessageBox errorBox = new AlertMessageBox(2, "Custom Resource Definitions Error!", "Unable to load cutom resource definition: " + caught.getMessage());
                    errorBox.open();
                }

                @Override
                public void onJemSuccess(ResourceDescriptor descriptor) {
                    ResourcesPropertiesPanel customResourcePanel = ExistingResourceInspector.this.renderCustomResourcePanel(descriptor);
                    if (customResourcePanel == null) {
                        AlertMessageBox box = new AlertMessageBox(2, "Oops!", "I have no panel that fit resource with type: '" + ExistingResourceInspector.this.getResource().getType() + "', sorry!");
                        box.open();
                    } else {
                        customResourcePanel.loadProperties();
                        ExistingResourceInspector.this.showResourcePanel(customResourcePanel);
                    }
                }

                @Override
                public void onJemExecuted() {
                }
            });
        }
    }

    @Override
    public void showResourcePanel(ResourcesPropertiesPanel activePanel) {
        int newAvailableWidth = this.getAvailableWidth();
        int newAvailableHeight = this.getAvailableHeight();
        this.mainContainer.add((Widget)this.resourcePanelContainer);
        this.resourcePanelContainer.setWidget((Widget)activePanel);
        this.resourcePanelContainer.setSize(Sizes.toString(newAvailableWidth), Sizes.toString(newAvailableHeight));
        activePanel.onResize(newAvailableWidth, newAvailableHeight);
    }

    @Override
    public void save() {
        if (this.checkMandatoryAttributes() && this.validate()) {
            Services.COMMON_RESOURCES_MANAGER.updateCommonResource(this.getResource(), (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                @Override
                public void onJemSuccess(Boolean result) {
                }

                @Override
                public void onJemFailure(Throwable caught) {
                    AlertMessageBox alert = new AlertMessageBox(2, "Update resource command error!", caught.getMessage());
                    alert.open();
                }

                @Override
                public void onJemExecuted() {
                    ExistingResourceInspector.this.hide();
                }
            });
        }
    }

    @Override
    public FlexTable getHeader() {
        return new ResourceHeader("[" + this.getResource().getType() + "] " + this.getResource().getName(), this);
    }
}

