/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources;

import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import java.util.HashMap;
import org.pepstock.jem.gwt.client.commons.AbstractInspector;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.Toast;
import org.pepstock.jem.gwt.client.panels.resources.inspector.Actions;
import org.pepstock.jem.gwt.client.panels.resources.inspector.FTPAttributesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.HTTPAttributesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.JDBCAttributesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.JMSAttributesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.JPPFAttributesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourcesPropertiesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.WidgetFactory;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.custom.ResourceDescriptor;

public abstract class AbstractResourceInspector
extends AbstractInspector {
    protected static final String JDBC = "JDBC";
    protected static final String FTP = "FTP";
    protected static final String JMS = "JMS";
    protected static final String HTTP = "HTTP";
    protected static final String JPPF = "JPPF";
    protected static final HashMap<String, Class<? extends ResourcesPropertiesPanel>> RESOURCES_TYPES;
    private Resource resource = null;
    protected VerticalPanel mainContainer = new VerticalPanel();
    protected SimplePanel resourcePanelContainer = new SimplePanel();
    private Actions actionsPanel = null;

    public AbstractResourceInspector(Resource resource) {
        super(true);
        this.resource = resource;
        this.actionsPanel = new Actions(resource);
        this.actionsPanel.setInspector(this);
    }

    public abstract void showResourcePanel(ResourcesPropertiesPanel var1);

    public void cancel() {
        this.hide();
    }

    public ResourcesPropertiesPanel renderOOTBResourcePanel(String ootbResourceType) {
        ResourcesPropertiesPanel ootbPanel = null;
        if (ootbResourceType.equals(JDBC)) {
            ootbPanel = new JDBCAttributesPanel(this.resource);
        } else if (ootbResourceType.equals(FTP)) {
            ootbPanel = new FTPAttributesPanel(this.resource);
        } else if (ootbResourceType.equals(JMS)) {
            ootbPanel = new JMSAttributesPanel(this.resource);
        } else if (ootbResourceType.equals(HTTP)) {
            ootbPanel = new HTTPAttributesPanel(this.resource);
        } else if (ootbResourceType.equals(JPPF)) {
            ootbPanel = new JPPFAttributesPanel(this.resource);
        } else {
            throw new IllegalArgumentException("I don't know the panel to render for resource type " + ootbResourceType);
        }
        return ootbPanel;
    }

    public ResourcesPropertiesPanel renderCustomResourcePanel(ResourceDescriptor resourceDescriptor) {
        return WidgetFactory.INSTANCE.renderResource(resourceDescriptor, this.resource);
    }

    protected boolean checkMandatoryAttributes() {
        ResourcesPropertiesPanel selectedPanel = (ResourcesPropertiesPanel)this.resourcePanelContainer.getWidget();
        boolean allMandatoryAttributesAreFilled = false;
        if (selectedPanel != null) {
            allMandatoryAttributesAreFilled = selectedPanel.checkMandatory();
        }
        if (!allMandatoryAttributesAreFilled) {
            Toast t = new Toast(1, "You have to fill all required attributes before save the resource", "Mandatory attributes missing");
            t.show();
        }
        return allMandatoryAttributesAreFilled;
    }

    public boolean validate() {
        ResourcesPropertiesPanel selectedPanel = (ResourcesPropertiesPanel)this.resourcePanelContainer.getWidget();
        boolean validated = false;
        if (selectedPanel != null) {
            validated = selectedPanel.validate();
        }
        return validated;
    }

    public abstract void save();

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public abstract FlexTable getHeader();

    @Override
    public Panel getContent() {
        return this.mainContainer;
    }

    @Override
    public Panel getActions() {
        return this.actionsPanel;
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        RESOURCES_TYPES = new HashMap();
        RESOURCES_TYPES.put(JDBC, JDBCAttributesPanel.class);
        RESOURCES_TYPES.put(FTP, FTPAttributesPanel.class);
        RESOURCES_TYPES.put(JMS, JMSAttributesPanel.class);
        RESOURCES_TYPES.put(HTTP, HTTPAttributesPanel.class);
        RESOURCES_TYPES.put(JPPF, JPPFAttributesPanel.class);
    }
}

