/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.nodes;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.view.client.SelectionModel;
import java.util.Iterator;
import java.util.LinkedList;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.AnchorTextColumn;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.NodeStatusImages;
import org.pepstock.jem.gwt.client.commons.TextFilterableHeader;
import org.pepstock.jem.gwt.client.commons.UpdateListener;
import org.pepstock.jem.gwt.client.panels.nodes.NodesComparator;
import org.pepstock.jem.gwt.client.security.ClientPermissions;
import org.pepstock.jem.util.filters.fields.NodeFilterFields;

public class NodesTable
extends AbstractTable<NodeInfoBean> {
    @Override
    public IndexedColumnComparator<NodeInfoBean> initCellTable(CellTable<NodeInfoBean> table) {
        Object affinity;
        Object domain;
        final SelectionModel selectionModel = table.getSelectionModel();
        Column<NodeInfoBean, Boolean> checkColumn = new Column<NodeInfoBean, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(NodeInfoBean nodeInfoBean) {
                return selectionModel.isSelected((Object)nodeInfoBean);
            }
        };
        CheckboxCell headerCheckBox = new CheckboxCell(true, false);
        Header<Boolean> checkHeader = new Header<Boolean>((Cell)headerCheckBox){

            public Boolean getValue() {
                if (NodesTable.this.getTable().getVisibleItems().isEmpty()) {
                    return false;
                }
                for (NodeInfoBean n : NodesTable.this.getTable().getVisibleItems()) {
                    if (NodesTable.this.getTable().getSelectionModel().isSelected((Object)n)) continue;
                    return false;
                }
                return true;
            }
        };
        checkHeader.setUpdater((ValueUpdater)new ValueUpdater<Boolean>(){

            public void update(Boolean value) {
                for (NodeInfoBean n : NodesTable.this.getTable().getVisibleItems()) {
                    NodesTable.this.getTable().getSelectionModel().setSelected((Object)n, value.booleanValue());
                }
            }
        });
        table.setColumnWidth((Column)checkColumn, 23.0, Style.Unit.PX);
        table.addColumn((Column)checkColumn, (Header)checkHeader);
        AnchorTextColumn<NodeInfoBean> name = new AnchorTextColumn<NodeInfoBean>(){

            @Override
            public String getValue(NodeInfoBean object) {
                return object.getLabel();
            }

            @Override
            public void onClick(int index, NodeInfoBean object, String value) {
                NodesTable.this.getInspectListener().inspect(object);
            }
        };
        name.setSortable(true);
        table.addColumn((Column)name, (Header)new TextFilterableHeader("Name", NodeFilterFields.NAME.getName()));
        TextColumn<NodeInfoBean> hostname = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.getHostname();
            }
        };
        hostname.setSortable(true);
        table.addColumn((Column)hostname, (Header)new TextFilterableHeader("Hostname", NodeFilterFields.HOSTNAME.getName()));
        if (ClientPermissions.isAuthorized("nodes", "nodes:update")) {
            domain = new Column<NodeInfoBean, String>((Cell)new EditTextCell()){

                public String getValue(NodeInfoBean nodeInfoBean) {
                    return nodeInfoBean.getExecutionEnvironment().getDomain();
                }
            };
            domain.setSortable(true);
            domain.setFieldUpdater((FieldUpdater)new FieldUpdater<NodeInfoBean, String>(){

                public void update(int index, NodeInfoBean nodeInfoBean, String value) {
                    if (value != null) {
                        if (value.trim().length() == 0) {
                            value = "***";
                        }
                        if (!value.equalsIgnoreCase(nodeInfoBean.getExecutionEnvironment().getDomain())) {
                            nodeInfoBean.getExecutionEnvironment().setDomain(value);
                            NodesTable.this.updateNode(nodeInfoBean);
                        }
                        return;
                    }
                    NodesTable.this.refresh();
                }
            });
            table.addColumn((Column)domain, (Header)new TextFilterableHeader("Domain", NodeFilterFields.DOMAIN.getName()));
        } else {
            domain = new TextColumn<NodeInfoBean>(){

                public String getValue(NodeInfoBean nodeInfoBean) {
                    return nodeInfoBean.getExecutionEnvironment().getDomain();
                }
            };
            domain.setSortable(true);
            table.addColumn((Column)domain, (Header)new TextFilterableHeader("Domain", NodeFilterFields.DOMAIN.getName()));
        }
        if (ClientPermissions.isAuthorized("nodes", "nodes:update")) {
            affinity = new Column<NodeInfoBean, String>((Cell)new EditTextCell()){

                public String getValue(NodeInfoBean nodeInfoBean) {
                    return NodesTable.this.toAffinityString(nodeInfoBean.getExecutionEnvironment().getStaticAffinities());
                }
            };
            affinity.setSortable(true);
            affinity.setFieldUpdater((FieldUpdater)new FieldUpdater<NodeInfoBean, String>(){

                public void update(int index, NodeInfoBean nodeInfoBean, String value) {
                    if (value != null) {
                        if (value.trim().length() == 0) {
                            value = "***";
                        }
                        nodeInfoBean.getExecutionEnvironment().getStaticAffinities().clear();
                        String[] affinities = value.split(",");
                        for (int i = 0; i < affinities.length; ++i) {
                            nodeInfoBean.getExecutionEnvironment().getStaticAffinities().add(affinities[i]);
                        }
                        NodesTable.this.updateNode(nodeInfoBean);
                        return;
                    }
                    NodesTable.this.refresh();
                }
            });
            table.addColumn((Column)affinity, (Header)new TextFilterableHeader("Static Affinities", NodeFilterFields.STATIC_AFFINITIES.getName()));
        } else {
            affinity = new TextColumn<NodeInfoBean>(){

                public String getValue(NodeInfoBean nodeInfoBean) {
                    return NodesTable.this.toAffinityString(nodeInfoBean.getExecutionEnvironment().getStaticAffinities());
                }
            };
            affinity.setSortable(true);
            table.addColumn((Column)affinity, (Header)new TextFilterableHeader("Static Affinities", NodeFilterFields.STATIC_AFFINITIES.getName()));
        }
        TextColumn<NodeInfoBean> dynAffinity = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return NodesTable.this.toAffinityString(nodeInfoBean.getExecutionEnvironment().getDynamicAffinities());
            }
        };
        dynAffinity.setSortable(true);
        table.addColumn((Column)dynAffinity, (Header)new TextFilterableHeader("Dynamic Affinities", NodeFilterFields.DYNAMIC_AFFINITIES.getName()));
        TextColumn<NodeInfoBean> status = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean object) {
                if (object == null || object.getStatus() == null) {
                    return "";
                }
                return object.getStatus();
            }

            public void render(Cell.Context context, NodeInfoBean object, SafeHtmlBuilder sb) {
                if (object == null || object.getStatus() == null || object.getStatus().trim().isEmpty()) {
                    return;
                }
                String statusString = object.getStatus();
                NodeStatusImages statusObject = statusString.equals(NodeStatusImages.UNKNOWN.toString()) ? NodeStatusImages.UNKNOWN : (statusString.equals(NodeStatusImages.STARTING.toString()) ? NodeStatusImages.STARTING : (statusString.equals(NodeStatusImages.INACTIVE.toString()) ? NodeStatusImages.INACTIVE : (statusString.equals(NodeStatusImages.ACTIVE.toString()) ? NodeStatusImages.ACTIVE : (statusString.equals(NodeStatusImages.DRAINED.toString()) ? NodeStatusImages.DRAINED : (statusString.equals(NodeStatusImages.DRAINING.toString()) ? NodeStatusImages.DRAINING : (statusString.equals(NodeStatusImages.SHUTTING_DOWN.toString()) ? NodeStatusImages.SHUTTING_DOWN : NodeStatusImages.INACTIVE))))));
                sb.appendHtmlConstant("<table>");
                sb.appendHtmlConstant("<tr><td>");
                String imageHtml = AbstractImagePrototype.create((ImageResource)statusObject.getImage()).getHTML();
                sb.appendHtmlConstant(imageHtml);
                sb.appendHtmlConstant("</td>");
                sb.appendHtmlConstant("<td align='left' valign='middle'>");
                sb.appendEscaped(statusString);
                if (!object.isOperational()) {
                    sb.appendEscaped(" (not operational)");
                }
                sb.appendHtmlConstant("</td></tr></table>");
            }
        };
        status.setSortable(true);
        table.addColumn((Column)status, (Header)new TextFilterableHeader("Status", NodeFilterFields.STATUS.getName()));
        TextColumn<NodeInfoBean> systemName = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.getSystemName();
            }
        };
        systemName.setSortable(true);
        table.addColumn((Column)systemName, (Header)new TextFilterableHeader("OS", NodeFilterFields.OS.getName()));
        TextColumn<NodeInfoBean> currentJob = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.getJobName() == null ? "" : nodeInfoBean.getJobName();
            }
        };
        currentJob.setSortable(true);
        table.addColumn((Column)currentJob, (Header)new TextFilterableHeader("Current Job", NodeFilterFields.CURRENT_JOB.getName()));
        return new NodesComparator(1);
    }

    private String toAffinityString(LinkedList<String> affinities) {
        if (affinities.isEmpty()) {
            return "";
        }
        Iterator i = affinities.iterator();
        StringBuilder sb = new StringBuilder();
        while (true) {
            String aff = (String)i.next();
            sb.append(aff);
            if (!i.hasNext()) {
                return sb.toString();
            }
            sb.append(",");
        }
    }

    private void refresh() {
        this.updateNode(null);
    }

    private void updateNode(NodeInfoBean node) {
        InspectListener listener = this.getInspectListener();
        if (listener instanceof UpdateListener) {
            UpdateListener ulistener = (UpdateListener)listener;
            ulistener.update(node);
        }
    }
}

