/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.nodes;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import java.util.Collection;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.components.AbstractActionsButtonPanel;
import org.pepstock.jem.gwt.client.security.ClientPermissions;
import org.pepstock.jem.gwt.client.services.Services;

public class NodesActions
extends AbstractActionsButtonPanel<NodeInfoBean> {
    public NodesActions() {
        this.init();
    }

    @Override
    protected void initButtons() {
        this.addStartButton();
        this.addDrainButton();
    }

    private void addStartButton() {
        if (ClientPermissions.isAuthorized("nodes", "nodes:start")) {
            Button startButton = new Button("Start", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MultiSelectionModel selectionModel = (MultiSelectionModel)NodesActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No node selected!", "No node is selected and it's not possible to perform START command.");
                        alert.open();
                        return;
                    }
                    NodesActions.this.start(selectionModel.getSelectedSet());
                    selectionModel.clear();
                }
            });
            this.add((Widget)startButton);
        }
    }

    private void addDrainButton() {
        if (ClientPermissions.isAuthorized("nodes", "nodes:drain")) {
            Button drainButton = new Button("Drain", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MultiSelectionModel selectionModel = (MultiSelectionModel)NodesActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No node selected!", "No node is selected and it's not possible to perform DRAIN command.");
                        alert.open();
                        return;
                    }
                    NodesActions.this.drain(selectionModel.getSelectedSet());
                    selectionModel.clear();
                }
            });
            this.add((Widget)drainButton);
        }
    }

    private void drain(final Collection<NodeInfoBean> nodes) {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.drain(nodes, (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                        if (NodesActions.this.getSearcher() != null) {
                            NodesActions.this.getSearcher().refresh();
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Drain command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        NodesActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }

    private void start(final Collection<NodeInfoBean> nodes) {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.start(nodes, (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                        if (NodesActions.this.getSearcher() != null) {
                            NodesActions.this.getSearcher().refresh();
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Start command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        NodesActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }
}

