/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.activity;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.chart.client.chart.Chart;
import com.sencha.gxt.chart.client.chart.Legend;
import com.sencha.gxt.chart.client.chart.axis.Axis;
import com.sencha.gxt.chart.client.chart.axis.CategoryAxis;
import com.sencha.gxt.chart.client.chart.axis.NumericAxis;
import com.sencha.gxt.chart.client.chart.series.LineSeries;
import com.sencha.gxt.chart.client.chart.series.Series;
import com.sencha.gxt.chart.client.draw.Color;
import com.sencha.gxt.chart.client.draw.RGB;
import com.sencha.gxt.chart.client.draw.path.PathSprite;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import java.util.List;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.activity.Data;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.activity.DataPropertyAccess;

public abstract class TimeSeriesChart
implements IsWidget {
    private static final DataPropertyAccess dataAccess = (DataPropertyAccess)GWT.create(DataPropertyAccess.class);
    private final Chart<Data> chart = new Chart();
    private final ListStore<Data> store = new ListStore(dataAccess.nameKey());
    private NumericAxis<Data> axis = null;
    private int width = 0;
    private int height = 0;
    private SimpleContainer panel = new SimpleContainer();

    public TimeSeriesChart() {
        this.chart.setShadowChart(true);
        this.chart.setAnimated(true);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public List<Data> getData() {
        return this.store.getAll();
    }

    public void setData(List<Data> data) {
        boolean redraw;
        boolean bl = redraw = this.store.size() == 0;
        if (redraw) {
            this.store.addAll(data);
        } else {
            this.store.replaceAll(data);
        }
        this.chart.setStore(this.store);
        if (redraw) {
            this.createNumericAxis();
            this.createCategoryAxis();
            this.createLineSeries();
            this.createLegend();
        }
        this.axis.setMaximum((double)this.getMaximum());
        this.chart.redrawChart();
    }

    public abstract int getMaximum();

    public abstract ValueProvider<Data, Double> getValueProvider();

    public abstract String getTitle();

    public abstract RGB getColor();

    public abstract Sprite getMarker();

    public Widget asWidget() {
        VerticalLayoutContainer layout = new VerticalLayoutContainer();
        this.panel.add((Widget)layout);
        this.chart.setLayoutData((Object)new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0));
        layout.add(this.chart);
        this.panel.setPixelSize(this.width, this.height);
        this.chart.redrawChart();
        return this.panel;
    }

    private void createNumericAxis() {
        this.axis = new NumericAxis();
        String title = this.getTitle();
        if (title != null) {
            TextSprite titleSprite = new TextSprite(title);
            titleSprite.setFontSize(12);
            this.axis.setTitleConfig(titleSprite);
        }
        this.axis.setPosition(Chart.Position.LEFT);
        this.axis.addField(this.getValueProvider());
        this.axis.setMinorTickSteps(1);
        this.axis.setDisplayGrid(true);
        PathSprite odd = new PathSprite();
        odd.setOpacity(1.0);
        odd.setFill(new Color("#ddd"));
        odd.setStroke(new Color("#bbb"));
        odd.setStrokeWidth(0.5);
        this.axis.setGridOddConfig(odd);
        this.axis.setMinimum(0.0);
        this.chart.addAxis(this.axis);
    }

    private void createCategoryAxis() {
        CategoryAxis catAxis = new CategoryAxis();
        catAxis.setPosition(Chart.Position.BOTTOM);
        catAxis.setField(dataAccess.key());
        TextSprite title = new TextSprite("samples");
        title.setFontSize(12);
        catAxis.setTitleConfig(title);
        this.chart.addAxis((Axis)catAxis);
    }

    private void createLineSeries() {
        LineSeries series = new LineSeries();
        series.setYAxisPosition(Chart.Position.LEFT);
        series.setYField(this.getValueProvider());
        series.setStroke((Color)this.getColor());
        series.setStrokeWidth(3.0);
        series.setShowMarkers(true);
        series.setSmooth(true);
        series.setFill((Color)this.getColor());
        Sprite marker = this.getMarker();
        marker.setFill((Color)this.getColor());
        series.setMarkerConfig(marker);
        series.setHighlighting(true);
        this.chart.addSeries((Series)series);
    }

    private void createLegend() {
        Legend legend = new Legend();
        legend.setPosition(Chart.Position.RIGHT);
        this.chart.setLegend(legend);
    }
}

