/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.commons.inspector;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.Job;
import org.pepstock.jem.JobSystemActivity;
import org.pepstock.jem.OSProcess;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.DefaultInspectorItem;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.UITools;
import org.pepstock.jem.gwt.client.services.Services;

public class SystemActivity
extends DefaultInspectorItem {
    private Loading loading = new Loading();
    private Job job = null;
    private HorizontalPanel hp = new HorizontalPanel();
    private ScrollPanel processesContainer = new ScrollPanel();
    private FlexTable layoutMem = new FlexTable();
    private FlexTable layoutCpu = new FlexTable();
    private FlexTable layoutProc = new FlexTable();
    private static final int SPACING = 5;
    private static final int FLEXTABLE_HEIGHT = 115;
    private Button getButton = null;

    public SystemActivity(Job job) {
        this.setJob(job);
        VerticalPanel main = new VerticalPanel();
        main.setWidth("100%");
        main.setHeight("100%");
        main.setSpacing(5);
        this.hp.setHeight(Sizes.toString(115));
        this.hp.setWidth("100%");
        main.add((Widget)this.hp);
        VerticalPanel cpuVp = new VerticalPanel();
        cpuVp.setWidth("100%");
        this.hp.add((Widget)cpuVp);
        this.hp.setCellWidth((Widget)cpuVp, "50%");
        Label cpuLabel = new Label("CPU information");
        cpuLabel.setWidth("100%");
        cpuLabel.setStyleName(Styles.INSTANCE.inspector().title());
        cpuLabel.addStyleName(Styles.INSTANCE.common().bold());
        cpuVp.add((Widget)cpuLabel);
        this.layoutCpu.setCellPadding(10);
        this.layoutCpu.setWidth("100%");
        this.layoutCpu.setHTML(0, 0, "Total CPU");
        this.layoutCpu.setHTML(0, 1, "");
        this.layoutCpu.setHTML(1, 0, "Current CPU");
        this.layoutCpu.setHTML(1, 1, "");
        UITools.setFlexTableStyles(this.layoutCpu, Styles.INSTANCE.inspector().rowDark(), Styles.INSTANCE.inspector().rowLight(), Styles.INSTANCE.common().bold());
        cpuVp.add((Widget)this.layoutCpu);
        VerticalPanel memVp = new VerticalPanel();
        memVp.setWidth("100%");
        this.hp.add((Widget)memVp);
        this.hp.setCellWidth((Widget)memVp, "50%");
        Label memLabel = new Label("Memory information");
        memLabel.setWidth("100%");
        memLabel.setStyleName(Styles.INSTANCE.inspector().title());
        memLabel.addStyleName(Styles.INSTANCE.common().bold());
        memVp.add((Widget)memLabel);
        this.layoutMem.setCellPadding(10);
        this.layoutMem.setWidth("100%");
        this.layoutMem.setHTML(0, 0, "Current memory utilization");
        this.layoutMem.setHTML(0, 1, "");
        UITools.setFlexTableStyles(this.layoutMem, Styles.INSTANCE.inspector().rowDark(), Styles.INSTANCE.inspector().rowLight(), Styles.INSTANCE.common().bold());
        memVp.add((Widget)this.layoutMem);
        this.processesContainer.setWidth("100%");
        VerticalPanel procVp = new VerticalPanel();
        procVp.setWidth("100%");
        Label procLabel = new Label("PROCESSES information");
        procLabel.setWidth("100%");
        procLabel.setStyleName(Styles.INSTANCE.inspector().title());
        procLabel.addStyleName(Styles.INSTANCE.common().bold());
        procVp.add((Widget)procLabel);
        this.layoutProc.setCellPadding(10);
        this.layoutProc.setWidth("100%");
        procVp.add((Widget)this.layoutProc);
        this.processesContainer.add((Widget)procVp);
        main.add((Widget)this.processesContainer);
        HorizontalPanel actions = new HorizontalPanel();
        actions.setHeight(Sizes.toString(44));
        this.getButton = new Button("Refresh", new ClickHandler(){

            public void onClick(ClickEvent event) {
                SystemActivity.this.getButton.setFocus(true);
                SystemActivity.this.getSystemActivity();
            }
        });
        this.getButton.addStyleName(Styles.INSTANCE.common().defaultActionButton());
        actions.add((Widget)this.getButton);
        main.add((Widget)actions);
        this.add((Widget)main);
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setFocus(boolean focus) {
        this.getButton.setFocus(focus);
        if (focus) {
            this.getSystemActivity();
        }
    }

    public void getSystemActivity() {
        if (!this.getButton.isEnabled()) {
            return;
        }
        this.loading.startProcessing();
        this.getButton.setEnabled(false);
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.getJobSystemActivity(SystemActivity.this.getJob(), (AsyncCallback<JobSystemActivity>)new ServiceAsyncCallback<JobSystemActivity>(){

                    @Override
                    public void onJemSuccess(JobSystemActivity result) {
                        if (result.isActive()) {
                            String display = NumberFormat.getFormat((String)"###,###,##0 ms").format((double)result.getCpu());
                            SystemActivity.this.layoutCpu.setHTML(0, 1, display);
                            display = NumberFormat.getFormat((String)"##0.00").format(result.getCpuPerc() * 100.0) + " %";
                            SystemActivity.this.layoutCpu.setHTML(1, 1, display);
                            display = NumberFormat.getFormat((String)"###,##0 MB").format((double)result.getMemory() / 1024.0 / 1024.0);
                            SystemActivity.this.layoutMem.setHTML(0, 1, display);
                            SystemActivity.this.layoutProc.removeAllRows();
                            SystemActivity.this.layoutProc.setHTML(0, 0, "Command");
                            SystemActivity.this.layoutProc.setHTML(0, 1, "PID");
                            SystemActivity.this.layoutProc.setHTML(0, 2, "Cpu");
                            SystemActivity.this.layoutProc.setHTML(0, 3, "Memory");
                            SystemActivity.this.createProcessesList(result.getProcess(), 0);
                            UITools.setFlexTableRowStyles(SystemActivity.this.layoutProc, Styles.INSTANCE.inspector().rowDark(), Styles.INSTANCE.inspector().rowLight());
                            UITools.setHeaderStyle(SystemActivity.this.layoutProc, Styles.INSTANCE.common().bold());
                        } else {
                            AlertMessageBox alert = new AlertMessageBox(1, "GetJobSystemActivty command error!", "Job '" + SystemActivity.this.getJob().getName() + "' is no longer running!");
                            alert.open();
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "GetJobSystemActivty command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        SystemActivity.this.loading.stopProcessing();
                        SystemActivity.this.getButton.setEnabled(true);
                    }
                });
            }
        });
    }

    private void createProcessesList(OSProcess process, int level) {
        int row = this.layoutProc.getRowCount();
        StringBuffer indent = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            indent.append("&nbsp;&nbsp;&nbsp;");
        }
        this.layoutProc.setHTML(row, 0, indent.toString() + process.getCommand());
        this.layoutProc.setHTML(row, 1, String.valueOf(process.getPid()));
        this.layoutProc.setHTML(row, 2, NumberFormat.getFormat((String)"###,###,##0 ms").format((double)process.getCpu()));
        this.layoutProc.setHTML(row, 3, NumberFormat.getFormat((String)"###,##0 MB").format((double)process.getMemory() / 1024.0 / 1024.0));
        for (OSProcess p : process.getChildren()) {
            this.createProcessesList(p, level + 1);
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int width = availableWidth;
        int height = availableHeight - 20 - 44 - 115;
        this.processesContainer.setSize(Sizes.toString(width -= 10), Sizes.toString(height));
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.inspector().ensureInjected();
    }
}

