/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.commons.inspector;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputFileContent;
import org.pepstock.jem.OutputListItem;
import org.pepstock.jem.OutputTree;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.editor.SyntaxHighlighter;
import org.pepstock.jem.gwt.client.editor.viewers.TextViewer;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.ItemAnchor;
import org.pepstock.jem.gwt.client.services.Services;

public class Output
extends SplitLayoutPanel
implements SyntaxHighlighter,
ResizeCapable {
    private final Loading loading = new Loading();
    private final VerticalPanel log = new VerticalPanel();
    private final ScrollPanel scrollerFiles = new ScrollPanel();
    private TextViewer viewOutput = new TextViewer();
    private HorizontalPanel selected = null;
    private boolean resized = false;

    public Output(Job job, OutputTree outputTree) {
        final Job thisJob = job;
        DisclosurePanel root = new DisclosurePanel(job.getName());
        root.setAnimationEnabled(true);
        VerticalPanel firstLevelPanel = new VerticalPanel();
        firstLevelPanel.setSpacing(1);
        for (OutputListItem item : outputTree.getFirstLevelItems()) {
            final HorizontalPanel options = new HorizontalPanel();
            options.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
            options.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            options.setSpacing(8);
            options.setWidth("100%");
            final ItemAnchor anchor = new ItemAnchor(item);
            anchor.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Output.this.output(thisJob, anchor.getItem());
                    Output.this.selectPanel(options);
                }
            });
            options.add((Widget)anchor);
            options.setCellWidth((Widget)anchor, "100%");
            firstLevelPanel.add((Widget)options);
        }
        root.setOpen(true);
        VerticalPanel secondAndFirstLevelPanel = new VerticalPanel();
        secondAndFirstLevelPanel.add((Widget)firstLevelPanel);
        for (String key : outputTree.getSecondLevelItems().keySet()) {
            DisclosurePanel secondPanel = new DisclosurePanel(key);
            secondPanel.setAnimationEnabled(true);
            VerticalPanel secondLevelPanel = new VerticalPanel();
            secondLevelPanel.setSpacing(1);
            for (OutputListItem item : (ArrayList)outputTree.getSecondLevelItems().get(key)) {
                final HorizontalPanel options = new HorizontalPanel();
                options.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
                options.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                options.setSpacing(8);
                options.setWidth("100%");
                final ItemAnchor anchor = new ItemAnchor(item);
                anchor.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        Output.this.output(thisJob, anchor.getItem());
                        Output.this.selectPanel(options);
                    }
                });
                options.add((Widget)anchor);
                options.setCellWidth((Widget)anchor, "100%");
                secondLevelPanel.add((Widget)options);
            }
            secondPanel.setContent((Widget)secondLevelPanel);
            secondAndFirstLevelPanel.add((Widget)secondPanel);
        }
        root.setContent((Widget)secondAndFirstLevelPanel);
        this.scrollerFiles.add((Widget)root);
        this.scrollerFiles.setWidth(Sizes.toString(200));
        this.log.add((Widget)this.viewOutput);
        this.log.setVisible(false);
        this.addWest((Widget)this.scrollerFiles, 200.0);
        this.add((Widget)this.log);
    }

    private void selectPanel(HorizontalPanel select) {
        if (select.equals(this.selected)) {
            return;
        }
        if (this.selected != null) {
            this.selected.setStyleName(Styles.INSTANCE.common().adminUnselectedTreeItem());
        }
        select.setStyleName(Styles.INSTANCE.common().adminSelectedTreeItem());
        this.selected = select;
    }

    public void output(final Job job, final OutputListItem item) {
        this.loading.startProcessing();
        this.log.setVisible(true);
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.getOutputFileContent(job, item, (AsyncCallback<OutputFileContent>)new ServiceAsyncCallback<OutputFileContent>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Get OUTPUT error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(OutputFileContent result) {
                        String content = null;
                        content = result.getContent() == null ? "(none)" : (result.getContent().trim().length() == 0 ? "(none)" : result.getContent());
                        Output.this.viewOutput.setContent(content);
                        Output.this.viewOutput.startEditor();
                    }

                    @Override
                    public void onJemExecuted() {
                        Output.this.loading.stopProcessing();
                    }
                });
            }
        });
    }

    public void onResize() {
        super.onResize();
        this.resized = this.getWidgetSize((Widget)this.scrollerFiles).intValue() != 200;
        this.onResize(this.getOffsetWidth(), this.getOffsetHeight());
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        this.setHeight(Sizes.toString(availableHeight));
        this.setWidth(Sizes.toString(availableWidth));
        this.scrollerFiles.setHeight(Sizes.toString(availableHeight));
        int syntaxHighlighterWidth = availableWidth - (this.resized ? this.getWidgetSize((Widget)this.scrollerFiles).intValue() : 200) - 8;
        int syntaxHighlighterHeight = availableHeight - 2;
        this.viewOutput.onResize(syntaxHighlighterWidth, syntaxHighlighterHeight);
    }

    @Override
    public void startEditor() {
    }

    @Override
    public void destroyEditor() {
        this.viewOutput.destroyEditor();
    }

    @Override
    public String getContent() {
        return null;
    }

    @Override
    public void setContent(String content) {
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    @Override
    public void setChanged(boolean changed) {
    }

    @Override
    public boolean isEditorStarted() {
        return false;
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.administration().ensureInjected();
    }
}

