/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.commons;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import java.util.Collection;
import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ConfirmMessageBox;
import org.pepstock.jem.gwt.client.commons.HideHandler;
import org.pepstock.jem.gwt.client.commons.PreferredButton;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.jobs.commons.AbstractJobsActions;
import org.pepstock.jem.gwt.client.panels.jobs.commons.Submitter;
import org.pepstock.jem.gwt.client.security.ClientPermissions;
import org.pepstock.jem.gwt.client.services.Services;

public class JobsBaseActions
extends AbstractJobsActions {
    private String queueName = null;

    public JobsBaseActions(String queueName) {
        this.queueName = queueName;
        this.init();
    }

    @Override
    protected void initButtons() {
        this.addPurgeButton();
        this.addHoldButton();
        this.addReleaseButton();
        if (this.queueName != null && this.queueName.equalsIgnoreCase("org.pepstock.jem.input")) {
            this.addSubmitButton();
        }
    }

    private void addReleaseButton() {
        if (ClientPermissions.isAuthorized("jobs", "jobs:release")) {
            Button releaseButton = new Button("Release", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MultiSelectionModel selectionModel = (MultiSelectionModel)JobsBaseActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No job selected!", "No job is selected and it's not possible to perform RELEASE command.");
                        alert.open();
                        return;
                    }
                    JobsBaseActions.this.release(selectionModel.getSelectedSet());
                    selectionModel.clear();
                }
            });
            this.add((Widget)releaseButton);
        }
    }

    private void addHoldButton() {
        if (ClientPermissions.isAuthorized("jobs", "jobs:hold")) {
            Button holdButton = new Button("Hold", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MultiSelectionModel selectionModel = (MultiSelectionModel)JobsBaseActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No job selected!", "No job is selected and it's not possible to perform HOLD command.");
                        alert.open();
                        return;
                    }
                    JobsBaseActions.this.hold(selectionModel.getSelectedSet());
                    selectionModel.clear();
                }
            });
            this.add((Widget)holdButton);
        }
    }

    private void addPurgeButton() {
        if (ClientPermissions.isAuthorized("jobs", "jobs:purge")) {
            Button purgeButton = new Button("Purge", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    final MultiSelectionModel selectionModel = (MultiSelectionModel)JobsBaseActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No job selected!", "No job is selected and it's not possible to perform PURGE command.");
                        alert.open();
                        return;
                    }
                    ConfirmMessageBox cd = new ConfirmMessageBox("Confirm PURGE", "Are you sure you want to purge the selected jobs?");
                    cd.setHideHandler(new HideHandler(){

                        @Override
                        public void onHide(PreferredButton button) {
                            if (button.getAction() == 2) {
                                JobsBaseActions.this.purge(selectionModel.getSelectedSet());
                                selectionModel.clear();
                            }
                        }
                    });
                    cd.open();
                }
            });
            this.add((Widget)purgeButton);
        }
    }

    private void addSubmitButton() {
        if (ClientPermissions.isAuthorized("jobs", "jobs:submit")) {
            Button submitButton = new Button("Submit", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Submitter inspector = new Submitter();
                    inspector.setWidth("600px");
                    inspector.setHeight("240px");
                    inspector.setModal(true);
                    inspector.setTitle("Submit");
                    inspector.center();
                    inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                        public void onClose(CloseEvent<PopupPanel> arg0) {
                            if (JobsBaseActions.this.getSearcher() != null) {
                                JobsBaseActions.this.getSearcher().refresh();
                            }
                        }
                    });
                }
            });
            this.add((Widget)submitButton);
        }
    }

    private void hold(final Collection<Job> jobs) {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.hold(jobs, JobsBaseActions.this.queueName, (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                        if (JobsBaseActions.this.getSearcher() != null) {
                            JobsBaseActions.this.getSearcher().refresh();
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Hold command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        JobsBaseActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }

    private void release(final Collection<Job> jobs) {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.release(jobs, JobsBaseActions.this.queueName, (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                        if (JobsBaseActions.this.getSearcher() != null) {
                            JobsBaseActions.this.getSearcher().refresh();
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Release command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        JobsBaseActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }

    private void purge(final Collection<Job> jobs) {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.purge(jobs, JobsBaseActions.this.queueName, (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                        if (JobsBaseActions.this.getSearcher() != null) {
                            JobsBaseActions.this.getSearcher().refresh();
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Purge command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        JobsBaseActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }
}

