/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.commons;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputTree;
import org.pepstock.jem.gwt.client.commons.AbstractTabPanelInspector;
import org.pepstock.jem.gwt.client.editor.AbstractSyntaxHighlighter;
import org.pepstock.jem.gwt.client.editor.SyntaxHighlighter;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.BrowseJcl;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.EditJcl;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.General;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.JobHeader;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.Output;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.SystemActivity;
import org.pepstock.jem.gwt.client.security.ClientPermissions;

public class JobInspector
extends AbstractTabPanelInspector {
    private Job job = null;
    private OutputTree outputTree = null;
    private AbstractSyntaxHighlighter jcl = null;
    private SyntaxHighlighter output = null;
    private TabPanel main = new TabPanel();

    public JobInspector(Job job) {
        this(job, null);
    }

    public JobInspector(Job job, OutputTree outputTree) {
        this.setJob(job);
        this.setOutputTree(outputTree);
        this.main.add((Widget)new General(job), "General");
        this.jcl = ClientPermissions.isAuthorized("jobs", "jobs:submit") ? new EditJcl(this, job.getJcl().getType()) : new BrowseJcl();
        this.jcl.setContent(job.getJcl().getContent());
        this.main.add((Widget)this.jcl, "JCL");
        if (job.getProcessId() != null && job.getEndedTime() == null) {
            this.main.add((Widget)new SystemActivity(job), "Activity");
        }
        if (outputTree != null) {
            this.output = new Output(job, outputTree);
            this.main.add((IsWidget)this.output, "Output");
        }
        this.main.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                Widget w;
                if ((Integer)event.getSelectedItem() == 2) {
                    Widget w2 = JobInspector.this.main.getWidget(2);
                    if (w2 instanceof SystemActivity) {
                        SystemActivity sa = (SystemActivity)w2;
                        sa.setFocus(true);
                    }
                } else if ((Integer)event.getSelectedItem() == 1 && (w = JobInspector.this.main.getWidget(1)) instanceof SyntaxHighlighter) {
                    SyntaxHighlighter jclSelected = (SyntaxHighlighter)w;
                    jclSelected.startEditor();
                }
            }
        });
        this.main.selectTab(0);
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public OutputTree getOutputTree() {
        return this.outputTree;
    }

    public void setOutputTree(OutputTree outputTree) {
        this.outputTree = outputTree;
    }

    @Override
    public FlexTable getHeader() {
        return new JobHeader(this.job.getName(), this);
    }

    public CellPanel getActions() {
        return null;
    }

    @Override
    public TabPanel getTabPanel() {
        return this.main;
    }

    public void hide() {
        super.hide();
        if (this.jcl != null) {
            this.jcl.destroyEditor();
        }
        if (this.output != null) {
            this.output.destroyEditor();
        }
    }

    public void hide(boolean autoClose) {
        super.hide(autoClose);
        if (this.jcl != null) {
            this.jcl.destroyEditor();
        }
        if (this.output != null) {
            this.output.destroyEditor();
        }
    }
}

