/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.gfs.commons;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.LinkedList;
import org.pepstock.jem.GfsFile;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.panels.gfs.commons.FilesTable;
import org.pepstock.jem.gwt.client.panels.gfs.commons.FilesTableContainer;
import org.pepstock.jem.gwt.client.panels.gfs.commons.GfsPanel;
import org.pepstock.jem.gwt.client.panels.gfs.commons.PathPanel;
import org.pepstock.jem.gwt.client.panels.gfs.commons.PathsSearcher;
import org.pepstock.jem.gwt.client.panels.gfs.inspector.FileInspector;
import org.pepstock.jem.gwt.client.security.CurrentUser;
import org.pepstock.jem.gwt.client.services.Services;

public abstract class FileSystemPanel
extends GfsPanel
implements SearchListener,
InspectListener<GfsFile>,
ResizeCapable {
    private final Loading loading = new Loading();
    private PathsSearcher searcher;
    private PathPanel pathPanel = new PathPanel();
    private FilesTableContainer files = null;
    private ScrollPanel scroller = null;
    private String preferenceKey = null;

    public FileSystemPanel(String preferencesKey) {
        this.setPreferenceKey(preferencesKey);
        this.searcher = new PathsSearcher(preferencesKey);
        this.files = new FilesTableContainer(this.getFilesTable());
        this.scroller = new ScrollPanel((Widget)this.files);
        this.add((Widget)this.searcher);
        this.searcher.setSearchListener(this);
        this.pathPanel.setWidth("100%");
        this.add((Widget)this.pathPanel);
        this.pathPanel.setListener(this);
        this.add((Widget)this.scroller);
        this.files.getFilesTable().setInspectListener(this);
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
    }

    public void load() {
        LinkedList<String> list;
        if (this.getPreferenceKey() != null && (list = CurrentUser.getInstance().getListPreference(this.getPreferenceKey())) != null && !list.isEmpty()) {
            this.search(list.getFirst());
            return;
        }
        this.search("*");
    }

    public abstract FilesTable getFilesTable();

    public abstract int getFilesType();

    public abstract boolean isOverviewOnly();

    @Override
    public void inspect(GfsFile file) {
        if (file.isDirectory()) {
            this.search(file);
            this.savePreference(file);
        } else if (!this.isOverviewOnly()) {
            this.loadFile(file);
        }
    }

    private void savePreference(GfsFile file) {
        if (this.getPreferenceKey() != null) {
            LinkedList<String> list = CurrentUser.getInstance().getListPreference(this.getPreferenceKey());
            if (list == null) {
                list = new LinkedList();
                CurrentUser.getInstance().setListPreference(this.getPreferenceKey(), list);
            }
            if (!list.contains(file.getLongName())) {
                list.addFirst(file.getLongName());
                if (list.size() > 10) {
                    list.removeLast();
                }
                CurrentUser.getInstance().setLastUpdateTime();
            } else {
                list.remove(file.getLongName());
                list.addFirst(file.getLongName());
                CurrentUser.getInstance().setLastUpdateTime();
            }
        }
    }

    @Override
    public void search(String filter) {
        GfsFile file = new GfsFile();
        file.setLongName(filter);
        file.setName(filter);
        file.setDirectory(true);
        this.inspect(file);
    }

    public void search(final GfsFile file) {
        final String filter = file.getLongName();
        this.searcher.setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.GFS_MANAGER.getFilesList(FileSystemPanel.this.getFilesType(), filter.equalsIgnoreCase("*") ? "." : filter, (AsyncCallback<Collection<GfsFile>>)new ServiceAsyncCallback<Collection<GfsFile>>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Get File system error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(Collection<GfsFile> result) {
                        FileSystemPanel.this.files.getFilesTable().setRowData(result);
                        FileSystemPanel.this.pathPanel.set(file, result.size());
                    }

                    @Override
                    public void onJemExecuted() {
                        FileSystemPanel.this.loading.stopProcessing();
                        FileSystemPanel.this.searcher.setEnabled(true);
                    }
                });
            }
        });
    }

    public void loadFile(final GfsFile file) {
        this.searcher.setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.GFS_MANAGER.getFile(FileSystemPanel.this.getFilesType(), file.getLongName(), (AsyncCallback<String>)new ServiceAsyncCallback<String>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Get File system error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(String result) {
                        FileInspector inspector = new FileInspector(file.getLongName(), result);
                        inspector.setModal(true);
                        inspector.setTitle(file.getLongName());
                        inspector.center();
                    }

                    @Override
                    public void onJemExecuted() {
                        FileSystemPanel.this.loading.stopProcessing();
                        FileSystemPanel.this.searcher.setEnabled(true);
                    }
                });
            }
        });
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int height = this.getHeight() - 44 - 44;
        this.scroller.setSize(Sizes.toString(this.getWidth()), Sizes.toString(height));
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

