/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.gfs;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.security.ClientPermissions;

public class TreeOptions
extends VerticalPanel {
    public static final String DATA_OPTION = "data";
    public static final String LIBRARY_OPTION = "library";
    public static final String SOURCES_OPTION = "sources";
    public static final String CLASS_OPTION = "class";
    public static final String BINARY_OPTION = "binary";
    private InspectListener<String> listener = null;
    private CellPanel selected = null;

    public TreeOptions() {
        this.setWidth("100%");
        this.setHeight("100%");
        HorizontalPanel header = new HorizontalPanel();
        header.setHorizontalAlignment(ALIGN_LEFT);
        header.setVerticalAlignment(ALIGN_MIDDLE);
        header.setSpacing(8);
        header.add((Widget)new Image(Images.INSTANCE.driveOpen_24()));
        header.add((Widget)new Label("Global file system"));
        DisclosurePanel admin = new DisclosurePanel();
        admin.setHeader((Widget)header);
        admin.setAnimationEnabled(true);
        admin.setOpen(true);
        CellPanel data = this.createItem("Data", DATA_OPTION, Images.INSTANCE.folderRed_24(), "gfs:data");
        CellPanel lib = this.createItem("Library", LIBRARY_OPTION, Images.INSTANCE.folderRed_24(), "gfs:library");
        CellPanel src = this.createItem("Sources", SOURCES_OPTION, Images.INSTANCE.folderRed_24(), "gfs:sources");
        CellPanel classes = this.createItem("Class", CLASS_OPTION, Images.INSTANCE.folderRed_24(), "gfs:class");
        CellPanel bin = this.createItem("Binary", BINARY_OPTION, Images.INSTANCE.folderRed_24(), "gfs:binary");
        VerticalPanel statusPanel = new VerticalPanel();
        if (data != null) {
            statusPanel.add((Widget)data);
        }
        if (lib != null) {
            statusPanel.add((Widget)lib);
        }
        if (src != null) {
            statusPanel.add((Widget)src);
        }
        if (classes != null) {
            statusPanel.add((Widget)classes);
        }
        if (bin != null) {
            statusPanel.add((Widget)bin);
        }
        if (statusPanel.getElement().getChildCount() > 0) {
            admin.setContent((Widget)statusPanel);
            Grid grid = new Grid(1, 1);
            grid.setWidget(0, 0, (Widget)admin);
            this.add((Widget)grid);
        }
    }

    public void setListener(InspectListener<String> listener) {
        this.listener = listener;
    }

    private void selectPanel(CellPanel select) {
        if (select.equals(this.selected)) {
            return;
        }
        if (this.selected != null) {
            this.selected.setStyleName(Styles.INSTANCE.common().adminUnselectedTreeItem());
        }
        select.setStyleName(Styles.INSTANCE.common().adminSelectedTreeItem());
        this.selected = select;
    }

    private final CellPanel createItem(String description, final String option, ImageResource icon, String permission) {
        if (!ClientPermissions.isAuthorized("gfs", permission)) {
            return null;
        }
        final HorizontalPanel options = new HorizontalPanel();
        options.setHorizontalAlignment(ALIGN_LEFT);
        options.setVerticalAlignment(ALIGN_MIDDLE);
        options.setSpacing(8);
        Anchor anchor = new Anchor(description);
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TreeOptions.this.listener != null) {
                    TreeOptions.this.listener.inspect(option);
                    TreeOptions.this.selectPanel((CellPanel)options);
                }
            }
        });
        if (icon != null) {
            options.add((Widget)new Image(icon));
        }
        options.add((Widget)anchor);
        this.setCellWidth((Widget)anchor, "100%");
        return options;
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

