/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.components;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.ConfirmMessageBox;
import org.pepstock.jem.gwt.client.commons.HideHandler;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.PreferredButton;
import org.pepstock.jem.gwt.client.commons.Styles;

public abstract class NewObjectHeader
extends FlexTable {
    private PopupPanel parent = null;
    private String editableText = null;
    private TextBox name = null;

    public NewObjectHeader(ImageResource icon, String editableText, PopupPanel parent) {
        this.parent = parent;
        this.editableText = editableText;
        this.name = new TextBox();
        this.name.setWidth("80%");
        this.name.setText(editableText);
        this.name.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewObjectHeader.this.name.selectAll();
            }
        });
        this.name.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                NewObjectHeader.this.onNameTyped(NewObjectHeader.this.name.getText());
            }
        });
        this.setWidth("100%");
        this.setCellSpacing(3);
        this.setCellPadding(1);
        this.addStyleName(Styles.INSTANCE.inspector().gradientBackground());
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        rf.setVerticalAlign(0, HasVerticalAlignment.ALIGN_MIDDLE);
        FlexTable.FlexCellFormatter cf = this.getFlexCellFormatter();
        cf.setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT);
        this.setWidget(0, 0, (Widget)new Image(icon));
        cf.setWidth(0, 1, "100%");
        cf.setHorizontalAlignment(0, 1, HasHorizontalAlignment.ALIGN_LEFT);
        this.name.setStylePrimaryName(Styles.INSTANCE.inspector().inputMain());
        this.setWidget(0, 1, (Widget)this.name);
        Image closeImage = new Image(Images.INSTANCE.close24());
        closeImage.addStyleName(Styles.INSTANCE.common().pointer());
        closeImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewObjectHeader.this.onClose(event);
            }
        });
        cf.setVerticalAlignment(0, 2, HasVerticalAlignment.ALIGN_TOP);
        cf.setHorizontalAlignment(0, 2, HasHorizontalAlignment.ALIGN_RIGHT);
        this.setWidget(0, 2, (Widget)closeImage);
    }

    protected void onLoad() {
        super.onLoad();
        new Timer(){

            public void run() {
                NewObjectHeader.this.name.setFocus(true);
                NewObjectHeader.this.name.selectAll();
            }
        }.schedule(0);
    }

    public void onClose(ClickEvent e) {
        if (this.isEdited()) {
            ConfirmMessageBox cd = new ConfirmMessageBox("Unsaved changes", "There are unsaved changes. Close anyway?");
            cd.setHideHandler(new HideHandler(){

                @Override
                public void onHide(PreferredButton button) {
                    if (button.getAction() == 2) {
                        NewObjectHeader.this.parent.hide();
                    }
                }
            });
            cd.open();
        } else {
            this.parent.hide();
        }
    }

    public abstract void onNameTyped(String var1);

    public boolean hasName() {
        return this.name != null && !this.name.getText().trim().isEmpty();
    }

    public String getName() {
        if (this.name != null) {
            return this.name.getText().trim();
        }
        return null;
    }

    public boolean isEdited() {
        String headerText = this.getName();
        if (headerText != null) {
            return !headerText.equals(this.editableText);
        }
        return false;
    }

    static {
        Styles.INSTANCE.inspector().ensureInjected();
        Styles.INSTANCE.common().ensureInjected();
    }
}

