/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.workload;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.chart.client.chart.Chart;
import com.sencha.gxt.chart.client.chart.Legend;
import com.sencha.gxt.chart.client.chart.axis.Axis;
import com.sencha.gxt.chart.client.chart.axis.CategoryAxis;
import com.sencha.gxt.chart.client.chart.axis.NumericAxis;
import com.sencha.gxt.chart.client.chart.series.LineSeries;
import com.sencha.gxt.chart.client.chart.series.Primitives;
import com.sencha.gxt.chart.client.chart.series.Series;
import com.sencha.gxt.chart.client.chart.series.SeriesLabelProvider;
import com.sencha.gxt.chart.client.chart.series.SeriesToolTipConfig;
import com.sencha.gxt.chart.client.draw.Color;
import com.sencha.gxt.chart.client.draw.RGB;
import com.sencha.gxt.chart.client.draw.path.PathSprite;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pepstock.jem.gwt.client.panels.administration.workload.Data;
import org.pepstock.jem.gwt.client.panels.administration.workload.DataPropertyAccess;

public class TimeSeriesChart
implements IsWidget {
    private static final DataPropertyAccess dataAccess = (DataPropertyAccess)GWT.create(DataPropertyAccess.class);
    private static final String TIME_AXIS = "Time";
    public static final int JOBS_SUBMITTED = 0;
    public static final int JCLS_CHECKED = 1;
    private final Chart<Data> chart = new Chart();
    private final ListStore<Data> store = new ListStore(dataAccess.nameKey());
    private NumericAxis<Data> axis = null;
    private int width = 0;
    private int height = 0;
    private int type = 0;
    private boolean loaded = false;
    private SimpleContainer panel = new SimpleContainer();

    public TimeSeriesChart(int type) {
        this.setType(type);
        this.chart.setShadowChart(true);
        this.chart.setAnimated(true);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setData(List<Data> data) {
        boolean redraw;
        boolean bl = redraw = this.store.size() == 0;
        if (redraw) {
            this.store.addAll(data);
        } else {
            this.store.replaceAll(data);
        }
        this.chart.setStore(this.store);
        if (redraw) {
            this.createNumericAxis();
            this.createCategoryAxis();
            this.createLineSeries();
            this.createLegend();
        }
        this.axis.setMaximum((double)this.max());
        this.chart.redrawChart();
        this.setLoaded(true);
    }

    private int max() {
        Data data = Collections.max(this.store.getAll(), new Comparator<Data>(){

            @Override
            public int compare(Data arg0, Data arg1) {
                int diff = 0;
                diff = TimeSeriesChart.this.getType() == 0 ? arg0.getJobsSubmitted() - arg1.getJobsSubmitted() : arg0.getJclsChecked() - arg1.getJclsChecked();
                return diff;
            }
        });
        int max = this.getType() == 0 ? data.getJobsSubmitted() : data.getJclsChecked();
        max = (max / 10 + 1) * 10;
        return max;
    }

    public Widget asWidget() {
        VerticalLayoutContainer layout = new VerticalLayoutContainer();
        this.panel.add((Widget)layout);
        this.chart.setLayoutData((Object)new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0));
        layout.add(this.chart);
        this.redraw();
        return this.panel;
    }

    public void redraw() {
        this.panel.setPixelSize(this.width, this.height);
        this.chart.redrawChart();
    }

    private void createNumericAxis() {
        this.axis = new NumericAxis();
        this.axis.setPosition(Chart.Position.LEFT);
        this.axis.addField(this.getType() == 0 ? dataAccess.jobsSubmitted() : dataAccess.jclsChecked());
        TextSprite titleSprite = new TextSprite("Number");
        titleSprite.setFontSize(12);
        this.axis.setTitleConfig(titleSprite);
        this.axis.setMinorTickSteps(1);
        this.axis.setDisplayGrid(true);
        PathSprite odd = new PathSprite();
        odd.setOpacity(1.0);
        odd.setFill(new Color("#ddd"));
        odd.setStroke(new Color("#bbb"));
        odd.setStrokeWidth(0.5);
        this.axis.setGridOddConfig(odd);
        this.axis.setMinimum(0.0);
        this.chart.addAxis(this.axis);
    }

    private void createCategoryAxis() {
        CategoryAxis catAxis = new CategoryAxis();
        catAxis.setPosition(Chart.Position.BOTTOM);
        catAxis.setField(dataAccess.key());
        TextSprite title = new TextSprite(TIME_AXIS);
        title.setFontSize(12);
        catAxis.setTitleConfig(title);
        catAxis.setLabelProvider((LabelProvider)new LabelProvider<String>(){

            public String getLabel(String item) {
                return item.substring(0, 5);
            }
        });
        this.chart.addAxis((Axis)catAxis);
    }

    private void createLineSeries() {
        LineSeries series = new LineSeries();
        series.setYAxisPosition(Chart.Position.LEFT);
        series.setYField(this.getType() == 0 ? dataAccess.jobsSubmitted() : dataAccess.jclsChecked());
        series.setStroke((Color)new RGB(32, 68, 186));
        series.setShowMarkers(true);
        series.setSmooth(true);
        series.setFill((Color)new RGB(32, 68, 186));
        PathSprite marker = Primitives.diamond((double)0.0, (double)0.0, (double)6.0);
        marker.setFill((Color)new RGB(32, 68, 186));
        series.setMarkerConfig((Sprite)marker);
        series.setHighlighting(true);
        SeriesToolTipConfig config = new SeriesToolTipConfig();
        config.setLabelProvider((SeriesLabelProvider)new SeriesLabelProvider<Data>(){

            public String getLabel(Data item, ValueProvider<? super Data, ? extends Number> valueProvider) {
                return "Count: " + String.valueOf(TimeSeriesChart.this.getType() == 0 ? item.getJobsSubmitted() : item.getJclsChecked());
            }
        });
        series.setToolTipConfig(config);
        this.chart.addSeries((Series)series);
    }

    private void createLegend() {
        Legend legend = new Legend();
        legend.setPosition(Chart.Position.RIGHT);
        this.chart.setLegend(legend);
    }
}

