/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.workload;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.Instances;
import org.pepstock.jem.gwt.client.panels.administration.workload.Data;
import org.pepstock.jem.gwt.client.panels.administration.workload.NodesTable;
import org.pepstock.jem.gwt.client.panels.administration.workload.TimeSeriesChart;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.node.stats.LightMemberSample;
import org.pepstock.jem.node.stats.LightSample;

public class OverviewPanel
extends AdminPanel
implements ResizeCapable {
    private final TabPanel mainTabPanel = new TabPanel();
    private TimeSeriesChart chartJobs = new TimeSeriesChart(0);
    private TimeSeriesChart chartJcls = new TimeSeriesChart(1);
    private TableContainer<LightMemberSample> nodes = new TableContainer<LightMemberSample>(new NodesTable());
    private ScrollPanel scroller = new ScrollPanel(this.nodes);
    private ArrayList<Data> listData = new ArrayList();
    private InspectListener<LightMemberSample> listener = null;
    private VerticalPanel jobPanel = new VerticalPanel();
    private VerticalPanel jclPanel = new VerticalPanel();

    public OverviewPanel() {
        this.mainTabPanel.add((Widget)this.jobPanel, "Jobs submitted", false);
        this.mainTabPanel.add((Widget)this.jclPanel, "Jcl checked", false);
        this.mainTabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                OverviewPanel.this.loadChart((Integer)event.getSelectedItem());
            }
        });
        this.add((Widget)this.mainTabPanel);
        this.add((Widget)this.scroller);
        this.setCellVerticalAlignment((Widget)this.scroller, ALIGN_TOP);
    }

    public InspectListener<LightMemberSample> getListener() {
        return this.listener;
    }

    public void setListener(InspectListener<LightMemberSample> listener) {
        this.listener = listener;
        this.nodes.getUnderlyingTable().setInspectListener(listener);
    }

    public void load() {
        this.listData.clear();
        for (LightSample sample : Instances.getSamples()) {
            int totJob = 0;
            int totJcl = 0;
            for (LightMemberSample msample : sample.getMembers()) {
                if (msample == null) continue;
                totJob = (int)((long)totJob + msample.getNumberOfJOBSubmitted());
                totJcl = (int)((long)totJcl + msample.getNumberOfJCLCheck());
            }
            Data data = new Data();
            data.setKey(sample.getTime());
            data.setJobsSubmitted(totJob);
            data.setJclsChecked(totJcl);
            this.listData.add(data);
        }
        this.nodes.getUnderlyingTable().setRowData(Instances.getLastSample().getMembers());
        this.chartJcls.setLoaded(false);
        this.chartJobs.setLoaded(false);
        this.mainTabPanel.selectTab(0, true);
    }

    private void loadChart(int selected) {
        if (selected == 0) {
            if (!this.chartJobs.isLoaded()) {
                this.chartJobs.setData(this.listData);
                if (this.jobPanel.getWidgetCount() == 0) {
                    this.jobPanel.add(this.chartJobs.asWidget());
                }
            }
        } else if (!this.chartJcls.isLoaded()) {
            this.chartJcls.setData(this.listData);
            if (this.jclPanel.getWidgetCount() == 0) {
                this.jclPanel.add((IsWidget)this.chartJcls);
            }
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int chartWidth = this.getWidth() - 6 - 6 - 1 - 1;
        int mainTabPanelHeight = 281;
        if (Window.Navigator.getUserAgent().contains("MSIE 8")) {
            mainTabPanelHeight -= 33;
        }
        this.chartJcls.setWidth(chartWidth);
        this.chartJobs.setWidth(chartWidth);
        this.chartJcls.setHeight(240);
        this.chartJobs.setHeight(240);
        this.mainTabPanel.setWidth(Sizes.toString(this.getWidth()));
        this.mainTabPanel.setHeight(Sizes.toString(mainTabPanelHeight));
        int height = this.getHeight() - mainTabPanelHeight;
        if (Window.Navigator.getUserAgent().contains("MSIE 8")) {
            height -= 33;
        }
        height = Math.max(height, 1);
        this.scroller.setHeight(Sizes.toString(height));
        this.scroller.setWidth(Sizes.toString(this.getWidth()));
    }
}

