/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.redo;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.redo.RedoTable;
import org.pepstock.jem.gwt.client.panels.administration.redo.RedoTableContainer;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.persistence.RedoStatement;

public class OverviewPanel
extends AdminPanel
implements ResizeCapable {
    private final Loading loading = new Loading();
    private RedoTableContainer nodes = new RedoTableContainer(new RedoTable());
    private ScrollPanel scroller = new ScrollPanel((Widget)this.nodes);

    public OverviewPanel() {
        this.add((Widget)this.scroller);
    }

    public void load() {
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.STATS_MANAGER.getAllRedoStatements((AsyncCallback<Collection<RedoStatement>>)new ServiceAsyncCallback<Collection<RedoStatement>>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Get REDO error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(Collection<RedoStatement> result) {
                        if (result != null) {
                            OverviewPanel.this.nodes.getRedosTable().setRowData(result);
                        } else {
                            AlertMessageBox alert = new AlertMessageBox(1, "REDO null!", "The result of get all REDO statements is empty.");
                            alert.open();
                        }
                    }

                    @Override
                    public void onJemExecuted() {
                        OverviewPanel.this.loading.stopProcessing();
                    }
                });
            }
        });
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        this.scroller.setHeight(Sizes.toString(this.getHeight()));
        this.scroller.setWidth(Sizes.toString(this.getWidth()));
    }
}

