/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.queues;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.chart.client.chart.Chart;
import com.sencha.gxt.chart.client.chart.Legend;
import com.sencha.gxt.chart.client.chart.axis.Axis;
import com.sencha.gxt.chart.client.chart.axis.CategoryAxis;
import com.sencha.gxt.chart.client.chart.axis.NumericAxis;
import com.sencha.gxt.chart.client.chart.series.BarSeries;
import com.sencha.gxt.chart.client.chart.series.Series;
import com.sencha.gxt.chart.client.chart.series.SeriesLabelProvider;
import com.sencha.gxt.chart.client.chart.series.SeriesToolTipConfig;
import com.sencha.gxt.chart.client.draw.Color;
import com.sencha.gxt.chart.client.draw.RGB;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pepstock.jem.gwt.client.panels.administration.queues.Data;
import org.pepstock.jem.gwt.client.panels.administration.queues.DataPropertyAccess;

public class BarChart
implements IsWidget {
    private static final DataPropertyAccess dataAccess = (DataPropertyAccess)GWT.create(DataPropertyAccess.class);
    private static final String QUEUES_AXIS = "Queues";
    public static final int ENTRIES = 0;
    private final Chart<Data> chart = new Chart();
    private final ListStore<Data> store = new ListStore(dataAccess.nameKey());
    private NumericAxis<Data> axis = null;
    private int width = 0;
    private int height = 0;
    private int type = 0;

    public BarChart(int type) {
        this.setType(type);
        this.chart.setShadowChart(true);
        this.chart.setAnimated(true);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setData(List<Data> data) {
        boolean redraw;
        boolean bl = redraw = this.store.size() == 0;
        if (redraw) {
            this.store.addAll(data);
        } else {
            this.store.replaceAll(data);
        }
        this.chart.setStore(this.store);
        if (redraw) {
            this.createNumericAxis();
            this.createCategoryAxis();
            this.createBars();
            this.createLegend();
        }
        this.axis.setMaximum((double)this.max());
        this.chart.redrawChart();
    }

    private int max() {
        Data data = Collections.max(this.store.getAll(), new Comparator<Data>(){

            @Override
            public int compare(Data arg0, Data arg1) {
                long diff = 0L;
                diff = arg0.getEntries() - arg1.getEntries();
                return (int)diff;
            }
        });
        long max = data.getEntries();
        max = (max / 10L + 1L) * 10L;
        return (int)max;
    }

    public Widget asWidget() {
        SimpleContainer panel = new SimpleContainer();
        panel.setPixelSize(this.width, this.height);
        VerticalLayoutContainer layout = new VerticalLayoutContainer();
        panel.add((Widget)layout);
        this.chart.setLayoutData((Object)new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0));
        layout.add(this.chart);
        return panel;
    }

    private void createNumericAxis() {
        this.axis = new NumericAxis();
        this.axis.setPosition(Chart.Position.BOTTOM);
        this.axis.addField(dataAccess.entries());
        TextSprite titleSprite = new TextSprite("Entries");
        titleSprite.setFontSize(12);
        this.axis.setTitleConfig(titleSprite);
        this.axis.setMinorTickSteps(1);
        this.axis.setDisplayGrid(true);
        this.axis.setMinimum(0.0);
        this.chart.addAxis(this.axis);
    }

    private void createCategoryAxis() {
        CategoryAxis catAxis = new CategoryAxis();
        catAxis.setPosition(Chart.Position.LEFT);
        catAxis.setField(dataAccess.key());
        TextSprite title = new TextSprite(QUEUES_AXIS);
        title.setFontSize(12);
        catAxis.setTitleConfig(title);
        this.chart.addAxis((Axis)catAxis);
    }

    private void createBars() {
        BarSeries bar = new BarSeries();
        bar.setYAxisPosition(Chart.Position.BOTTOM);
        bar.addYField(dataAccess.entries());
        bar.addColor((Color)new RGB(148, 174, 10));
        bar.setHighlighting(true);
        this.chart.addSeries((Series)bar);
        SeriesToolTipConfig config = new SeriesToolTipConfig();
        config.setLabelProvider((SeriesLabelProvider)new SeriesLabelProvider<Data>(){

            public String getLabel(Data item, ValueProvider<? super Data, ? extends Number> valueProvider) {
                return "Entries: " + String.valueOf(item.getEntries());
            }
        });
        bar.setToolTipConfig(config);
    }

    private void createLegend() {
        Legend legend = new Legend();
        legend.setPosition(Chart.Position.RIGHT);
        this.chart.setLegend(legend);
    }
}

