/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.nodessystem.inspector;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.BackListener;
import org.pepstock.jem.gwt.client.panels.administration.commons.InspectorHeader;
import org.pepstock.jem.gwt.client.panels.administration.commons.Instances;
import org.pepstock.jem.gwt.client.panels.administration.nodessystem.inspector.Data;
import org.pepstock.jem.gwt.client.panels.administration.nodessystem.inspector.NodesTable;
import org.pepstock.jem.gwt.client.panels.administration.nodessystem.inspector.TimeSeriesChart;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.node.stats.LightMemberSample;
import org.pepstock.jem.node.stats.LightMemberSampleComparator;
import org.pepstock.jem.node.stats.LightSample;

public class InspectorPanel
extends AdminPanel
implements ResizeCapable {
    final TabPanel mainTabPanel = new TabPanel();
    private TimeSeriesChart chartMCpu = new TimeSeriesChart(0);
    private TimeSeriesChart chartPCpu = new TimeSeriesChart(1);
    private TimeSeriesChart chartPMem = new TimeSeriesChart(2);
    private TableContainer<LightMemberSample> nodes = new TableContainer<LightMemberSample>(new NodesTable());
    private ScrollPanel scroller = new ScrollPanel(this.nodes);
    private InspectorHeader header = new InspectorHeader("Host:");
    private ArrayList<Data> listData = new ArrayList();
    private VerticalPanel mCpuPanel = new VerticalPanel();
    private VerticalPanel pCpuPanel = new VerticalPanel();
    private VerticalPanel pMemPanel = new VerticalPanel();

    public InspectorPanel() {
        this.mainTabPanel.add((Widget)this.mCpuPanel, "Machine CPU %", false);
        this.mainTabPanel.add((Widget)this.pCpuPanel, "Process CPU %", false);
        this.mainTabPanel.add((Widget)this.pMemPanel, "Process Memory used", false);
        this.mainTabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                InspectorPanel.this.loadChart((Integer)event.getSelectedItem());
            }
        });
        this.add((Widget)this.header);
        this.add((Widget)this.mainTabPanel);
        this.add((Widget)this.scroller);
    }

    public BackListener getListener() {
        return this.header.getListener();
    }

    public void setListener(BackListener listener) {
        this.header.setListener(listener);
    }

    public void load(String memberKey) {
        this.listData.clear();
        ArrayList<LightMemberSample> list = new ArrayList<LightMemberSample>();
        boolean set = true;
        for (LightSample sample : Instances.getSamples()) {
            for (LightMemberSample msample : sample.getMembers()) {
                if (!msample.getMemberKey().equalsIgnoreCase(memberKey)) continue;
                Data data = new Data();
                data.setKey(sample.getTime());
                data.setMachineCpuPercent(msample.getCpuPercent() * 100.0);
                data.setProcessCpuPercent(msample.getProcessCpuPercent() * 100.0);
                data.setProcessMemoryUtil(msample.getProcessMemoryUsed() / 1024L / 1024L);
                this.listData.add(data);
                list.add(msample);
                if (!set) continue;
                set = false;
                this.header.setTitle(msample.getMemberLabel() + " - " + msample.getMemberHostname());
            }
        }
        Collections.sort(list, new LightMemberSampleComparator());
        this.nodes.getUnderlyingTable().setRowData(list);
        this.chartMCpu.setLoaded(false);
        this.chartPCpu.setLoaded(false);
        this.chartPMem.setLoaded(false);
        this.mainTabPanel.selectTab(0, true);
    }

    private void loadChart(int selected) {
        if (selected == 0) {
            if (!this.chartMCpu.isLoaded()) {
                this.chartMCpu.setData(this.listData);
                if (this.mCpuPanel.getWidgetCount() == 0) {
                    this.mCpuPanel.add(this.chartMCpu.asWidget());
                }
            }
        } else if (selected == 1) {
            if (!this.chartPCpu.isLoaded()) {
                this.chartPCpu.setData(this.listData);
                if (this.pCpuPanel.getWidgetCount() == 0) {
                    this.pCpuPanel.add(this.chartPCpu.asWidget());
                }
            }
        } else if (!this.chartPMem.isLoaded()) {
            this.chartPMem.setData(this.listData);
            if (this.pMemPanel.getWidgetCount() == 0) {
                this.pMemPanel.add((IsWidget)this.chartPMem);
            }
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int chartWidth = this.getWidth() - 6 - 6 - 1 - 1;
        int mainTabPanelHeight = 281;
        if (Window.Navigator.getUserAgent().contains("MSIE 8")) {
            mainTabPanelHeight -= 33;
        }
        this.chartMCpu.setWidth(chartWidth);
        this.chartPCpu.setWidth(chartWidth);
        this.chartPMem.setWidth(chartWidth);
        this.chartMCpu.setHeight(240);
        this.chartPCpu.setHeight(240);
        this.chartPMem.setHeight(240);
        this.mainTabPanel.setWidth(Sizes.toString(this.getWidth()));
        this.mainTabPanel.setHeight(Sizes.toString(mainTabPanelHeight));
        int height = this.getHeight() - mainTabPanelHeight - 40;
        if (Window.Navigator.getUserAgent().contains("MSIE 8")) {
            height -= 33;
        }
        height = Math.max(height, 1);
        this.scroller.setHeight(Sizes.toString(height));
        this.scroller.setWidth(Sizes.toString(this.getWidth()));
        this.header.setHeight(Sizes.toString(40));
        this.header.setWidth(Sizes.toString(this.getWidth()));
    }
}

