/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.nodesconfig.commands;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.CommandExecutor;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.ResultPanel;
import org.pepstock.jem.gwt.client.services.Services;

public class TopCommand
extends CommandExecutor {
    private static final int TOP = 1;
    private static final String LABEL = "Exec Top";
    private static final String TITLE = "Top command result";

    public TopCommand() {
        this.setIndex(1);
        this.setTitle(TITLE);
        this.setLabel(LABEL);
    }

    @Override
    public void execute(final NodeInfoBean node, final ResultPanel resultPanel) {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.top(node, (AsyncCallback<String>)new ServiceAsyncCallback<String>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Top Command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(String result) {
                        if (result != null) {
                            resultPanel.setResult(result);
                        } else {
                            AlertMessageBox alert = new AlertMessageBox(1, "Top Command warning!", "Top Command result is null. <br>Please have a look to JEM node log");
                            alert.open();
                        }
                    }

                    @Override
                    public void onJemExecuted() {
                        TopCommand.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }
}

