/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.nodesconfig;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.editor.Editor;
import org.pepstock.jem.gwt.client.editor.actions.Discard;
import org.pepstock.jem.gwt.client.editor.actions.SelectAll;
import org.pepstock.jem.gwt.client.editor.modifiers.PolicyModifier;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminEditor;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.ConfigurationFile;
import org.pepstock.jem.node.affinity.Result;

public class PolicyEditor
extends PolicyModifier
implements AdminEditor {
    private static final Image imgSaveDisabled = new Image(Images.INSTANCE.edit_save_disabled());
    private static final Image imgSave = new Image(Images.INSTANCE.edit_save());
    private static final String DESCRIPTION = "Policy";
    private final Loading loading = new Loading();
    private String description = "Policy";
    private NodeInfoBean node = null;
    private ConfigurationFile configurationFile = null;
    private MenuItem save = null;

    public PolicyEditor(String id) {
        super(id);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public NodeInfoBean getNode() {
        return this.node;
    }

    public void setNode(NodeInfoBean node) {
        this.node = node;
    }

    public ConfigurationFile getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void setEditorAttributes(Editor editor) {
        super.setEditorAttributes(editor);
        if (this.save != null) {
            this.onChange(false);
        }
    }

    @Override
    public void setMenuItems(MenuBar menu) {
        Discard discard = new Discard(this);
        SelectAll selectAll = new SelectAll(this);
        Image imgSelectAll = new Image(Images.INSTANCE.edit_check());
        imgSelectAll.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        MenuItem check = new MenuItem(imgSelectAll + " Check", true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                if (PolicyEditor.this.getNode() != null) {
                    if (PolicyEditor.this.getEditor().getText().trim().length() > 0) {
                        PolicyEditor.this.check();
                    } else {
                        AlertMessageBox alert = new AlertMessageBox(1, "Unable to check policy content!", "Policy content is empty. Check is not allowed!");
                        alert.open();
                    }
                }
            }
        });
        check.getElement().getStyle().setFontWeight(Style.FontWeight.NORMAL);
        menu.addItem(selectAll.getItem());
        menu.addItem(check);
        this.save = new MenuItem(imgSaveDisabled + " Save", true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                if (PolicyEditor.this.getEditor().getText().trim().length() > 0) {
                    PolicyEditor.this.configurationFile.setContent(PolicyEditor.this.getEditor().getText());
                    PolicyEditor.this.save();
                } else {
                    AlertMessageBox alert = new AlertMessageBox(1, "Unable to check policy!", "Policy is empty. Check is not allowed!");
                    alert.open();
                }
            }
        });
        this.save.getElement().getStyle().setFontWeight(Style.FontWeight.NORMAL);
        this.onChange(false);
        menu.addSeparator();
        menu.addItem(discard.getItem());
        menu.addItem(this.save);
    }

    private void check() {
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.checkAffinityPolicy(PolicyEditor.this.getNode(), PolicyEditor.this.getEditor().getText(), (AsyncCallback<Result>)new ServiceAsyncCallback<Result>(){

                    @Override
                    public void onJemSuccess(Result result) {
                        AlertMessageBox alert = new AlertMessageBox(0, "Policy checked!", "Policy has been correctly checked. " + result);
                        alert.open();
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Policy check error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        PolicyEditor.this.loading.stopProcessing();
                    }
                });
            }
        });
    }

    @Override
    public void onChange(boolean changed) {
        this.save.setEnabled(changed);
        if (changed) {
            this.save.setHTML(imgSave + " Save");
            this.save.getElement().getStyle().setColor("#000");
        } else {
            this.save.setHTML(imgSaveDisabled + " Save");
            this.save.getElement().getStyle().setColor("#ccc");
        }
    }

    private void save() {
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.saveNodeConfigFile(PolicyEditor.this.getNode(), PolicyEditor.this.getConfigurationFile(), "affinity", (AsyncCallback<ConfigurationFile>)new ServiceAsyncCallback<ConfigurationFile>(){

                    @Override
                    public void onJemSuccess(ConfigurationFile result) {
                        PolicyEditor.this.setConfigurationFile(result);
                        PolicyEditor.this.setContent(result.getContent());
                        PolicyEditor.this.setChanged(false);
                        AlertMessageBox alert = new AlertMessageBox(0, "Policy saved!", "Policy has been correctly saved.");
                        alert.open();
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Policy save error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        PolicyEditor.this.loading.stopProcessing();
                    }
                });
            }
        });
    }

    static {
        imgSaveDisabled.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        imgSave.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
    }
}

