/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.nodesconfig;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.MenuBar;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.administration.commons.XmlConfigEditor;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.ConfigurationFile;

public class NodeConfigEditor
extends XmlConfigEditor {
    private final Loading loading = new Loading();
    private NodeInfoBean node = null;

    public NodeConfigEditor(String id, String editType) {
        super(id, editType, "JEM node configuration");
    }

    public NodeInfoBean getNode() {
        return this.node;
    }

    public void setNode(NodeInfoBean node) {
        this.node = node;
    }

    @Override
    public void setMenuItems(MenuBar menu) {
        super.setMenuItems(menu);
    }

    @Override
    public void save() {
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.saveNodeConfigFile(NodeConfigEditor.this.getNode(), NodeConfigEditor.this.getConfigurationFile(), "jem.config", (AsyncCallback<ConfigurationFile>)new ServiceAsyncCallback<ConfigurationFile>(){

                    @Override
                    public void onJemSuccess(ConfigurationFile result) {
                        NodeConfigEditor.this.setConfigurationFile(result);
                        NodeConfigEditor.this.setContent(result.getContent());
                        NodeConfigEditor.this.setChanged(false);
                        AlertMessageBox alert = new AlertMessageBox(0, "Content saved!", NodeConfigEditor.this.getDescription() + " has been correctly saved.");
                        alert.open();
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Content save error!", NodeConfigEditor.this.getDescription() + ": " + caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        NodeConfigEditor.this.loading.stopProcessing();
                    }
                });
            }
        });
    }
}

