/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.nodesconfig;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.editor.Mode;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminEditor;
import org.pepstock.jem.gwt.client.panels.administration.commons.EditorContainer;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.NodeConfigEditor;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.PolicyEditor;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.ConfigurationFile;

public class ConfigPanel
extends VerticalPanel
implements ResizeCapable,
InspectListener<NodeInfoBean> {
    private static final String JEM_ID = "jemEditorID";
    private static final String AFFINITY_ID = "affinityEditorID";
    private final Loading loading = new Loading();
    private TabPanel tabPanel = new TabPanel();
    private NodeConfigEditor nodeConfig = new NodeConfigEditor("jemEditorID", "jem.config");
    private PolicyEditor affinity = new PolicyEditor("affinityEditorID");
    private NodeInfoBean node = null;
    private EditorContainer editorContainer = new EditorContainer();

    public ConfigPanel() {
        this.editorContainer.add((Widget)this.tabPanel);
        this.editorContainer.setEditors(new AdminEditor[]{this.nodeConfig, this.affinity});
    }

    public EditorContainer getEditorContainer() {
        return this.editorContainer;
    }

    @Override
    public void inspect(NodeInfoBean object) {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.node = object;
        if (this.tabPanel.getWidgetCount() == 0) {
            this.tabPanel.add((Widget)this.nodeConfig, "Node");
            this.tabPanel.add((Widget)this.affinity, "Affinity policy");
            this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

                public void onSelection(SelectionEvent<Integer> event) {
                    if (!ConfigPanel.this.tabPanel.isVisible()) {
                        ConfigPanel.this.tabPanel.setVisible(true);
                    }
                    if ((Integer)event.getSelectedItem() == 0) {
                        if (!ConfigPanel.this.nodeConfig.isChanged()) {
                            ConfigPanel.this.inspect((Integer)event.getSelectedItem());
                        }
                    } else if (!ConfigPanel.this.affinity.isChanged()) {
                        ConfigPanel.this.inspect((Integer)event.getSelectedItem());
                    }
                }
            });
        }
        this.affinity.setNode(object);
        this.nodeConfig.setNode(object);
        this.nodeConfig.setChanged(false);
        this.affinity.setChanged(false);
        this.editorContainer.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                ConfigPanel.this.editorContainer.setPopupPosition(ConfigPanel.this.getAbsoluteLeft(), ConfigPanel.this.getAbsoluteTop());
            }
        });
        this.tabPanel.selectTab(0, true);
    }

    @Override
    private void inspect(final int what) {
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.getNodeConfigFile(ConfigPanel.this.node, what == 0 ? "jem.config" : "affinity", (AsyncCallback<ConfigurationFile>)new ServiceAsyncCallback<ConfigurationFile>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        if (what == 0) {
                            ConfigPanel.this.nodeConfig.setContent(null);
                            ConfigPanel.this.nodeConfig.startEditor();
                            ConfigPanel.this.nodeConfig.setReadOnly(true);
                        } else {
                            ConfigPanel.this.affinity.setContent(null);
                            ConfigPanel.this.affinity.startEditor();
                            ConfigPanel.this.affinity.setReadOnly(true);
                        }
                        AlertMessageBox alert = new AlertMessageBox(2, "Get CONFIG file error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(ConfigurationFile result) {
                        if (result != null) {
                            if (what == 0) {
                                ConfigPanel.this.nodeConfig.setConfigurationFile(result);
                                ConfigPanel.this.nodeConfig.setContent(result.getContent());
                                ConfigPanel.this.nodeConfig.startEditor();
                                ConfigPanel.this.nodeConfig.setReadOnly(false);
                            } else {
                                boolean found = false;
                                for (Mode mode : Mode.values()) {
                                    if (!mode.getName().endsWith(result.getType())) continue;
                                    found = true;
                                }
                                ConfigPanel.this.affinity.setConfigurationFile(result);
                                ConfigPanel.this.affinity.setContent(result.getContent());
                                if (found) {
                                    ConfigPanel.this.affinity.setLanguage(result.getType());
                                } else {
                                    AlertMessageBox alert = new AlertMessageBox(2, "Script language unknown!", "The script language '" + result.getType() + "' is not supported or not configured. Plain text syntax is used.");
                                    alert.open();
                                    ConfigPanel.this.affinity.setLanguage(Mode.TEXT.getName());
                                }
                                ConfigPanel.this.affinity.startEditor();
                                ConfigPanel.this.affinity.setReadOnly(false);
                            }
                        } else {
                            if (what == 0) {
                                ConfigPanel.this.nodeConfig.setContent(null);
                                ConfigPanel.this.nodeConfig.startEditor();
                                ConfigPanel.this.nodeConfig.setReadOnly(true);
                            } else {
                                ConfigPanel.this.affinity.setContent(null);
                                ConfigPanel.this.affinity.startEditor();
                                ConfigPanel.this.affinity.setReadOnly(true);
                            }
                            AlertMessageBox alert = new AlertMessageBox(2, "Get CONFIG file null!", "The result, while retrieving the configuration file, is null,");
                            alert.open();
                        }
                    }

                    @Override
                    public void onJemExecuted() {
                        ConfigPanel.this.loading.stopProcessing();
                    }
                });
            }
        });
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        this.tabPanel.setSize(Sizes.toString(availableWidth), Sizes.toString(availableHeight));
        int syntaxHighlighterHeight = availableHeight - 33 - 4 - 2;
        int syntaxHighlighterWidth = availableWidth - 4 - 4 - 2 - 2;
        this.nodeConfig.onResize(syntaxHighlighterWidth, syntaxHighlighterHeight);
        this.affinity.onResize(syntaxHighlighterWidth, syntaxHighlighterHeight);
        if (this.editorContainer.isShowing()) {
            this.editorContainer.setPopupPosition(this.getAbsoluteLeft(), this.getAbsoluteTop());
        }
    }
}

