/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.memory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.chart.client.chart.Chart;
import com.sencha.gxt.chart.client.chart.Legend;
import com.sencha.gxt.chart.client.chart.series.PieSeries;
import com.sencha.gxt.chart.client.chart.series.Series;
import com.sencha.gxt.chart.client.chart.series.SeriesLabelConfig;
import com.sencha.gxt.chart.client.chart.series.SeriesLabelProvider;
import com.sencha.gxt.chart.client.chart.series.SeriesToolTipConfig;
import com.sencha.gxt.chart.client.draw.Color;
import com.sencha.gxt.chart.client.draw.RGB;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.StringLabelProvider;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import java.util.List;
import org.pepstock.jem.gwt.client.panels.administration.memory.Data;
import org.pepstock.jem.gwt.client.panels.administration.memory.DataPropertyAccess;

public class PieChart
implements IsWidget {
    private static final DataPropertyAccess dataAccess = (DataPropertyAccess)GWT.create(DataPropertyAccess.class);
    private final Chart<Data> chart = new Chart();
    private final ListStore<Data> store = new ListStore(dataAccess.nameKey());
    private RGB blue = new RGB(164, 175, 210);
    private RGB red = RGB.RED;
    private int width = 0;
    private int height = 0;

    public PieChart() {
        this.chart.setShadowChart(true);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setData(List<Data> data) {
        boolean redraw;
        boolean bl = redraw = this.store.size() == 0;
        if (redraw) {
            this.store.addAll(data);
        } else {
            this.store.replaceAll(data);
        }
        this.chart.setStore(this.store);
        if (redraw) {
            this.createPie();
            this.createLegend();
        }
        this.chart.redrawChart();
    }

    public Widget asWidget() {
        SimpleContainer panel = new SimpleContainer();
        panel.setPixelSize(this.width, this.height);
        VerticalLayoutContainer layout = new VerticalLayoutContainer();
        panel.add((Widget)layout);
        this.chart.setLayoutData((Object)new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0));
        layout.add(this.chart);
        return panel;
    }

    private void createPie() {
        PieSeries series = new PieSeries();
        series.setAngleField(dataAccess.value());
        series.setDonut(35.0);
        series.addColor((Color)this.blue);
        series.addColor((Color)this.red);
        TextSprite textConfig = new TextSprite();
        textConfig.setFont("Arial");
        textConfig.setTextBaseline(TextSprite.TextBaseline.MIDDLE);
        textConfig.setFontSize(18);
        textConfig.setTextAnchor(TextSprite.TextAnchor.MIDDLE);
        textConfig.setZIndex(15);
        SeriesLabelConfig labelConfig = new SeriesLabelConfig();
        labelConfig.setSpriteConfig((Sprite)textConfig);
        labelConfig.setLabelPosition(Series.LabelPosition.START);
        labelConfig.setValueProvider(dataAccess.key(), (LabelProvider)new StringLabelProvider());
        series.setLabelConfig(labelConfig);
        series.setHighlighting(true);
        series.setLegendValueProvider(dataAccess.key(), (LabelProvider)new StringLabelProvider());
        this.chart.addSeries((Series)series);
        SeriesToolTipConfig config = new SeriesToolTipConfig();
        config.setLabelProvider((SeriesLabelProvider)new SeriesLabelProvider<Data>(){

            public String getLabel(Data item, ValueProvider<? super Data, ? extends Number> valueProvider) {
                return item.getKey() + ": " + NumberFormat.getFormat((String)"##0.00 %").format(item.getPercent()) + ", " + NumberFormat.getFormat((String)"###,###,##0 MB").format((double)item.getValue() / 1024.0 / 1024.0);
            }
        });
        series.setToolTipConfig(config);
    }

    private void createLegend() {
        Legend legend = new Legend();
        legend.setPosition(Chart.Position.RIGHT);
        this.chart.setLegend(legend);
    }
}

