/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.gfs;

import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.Instances;
import org.pepstock.jem.gwt.client.panels.administration.gfs.Data;
import org.pepstock.jem.gwt.client.panels.administration.gfs.GfsTable;
import org.pepstock.jem.gwt.client.panels.administration.gfs.PieChart;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.node.stats.LightMemberSample;
import org.pepstock.jem.node.stats.LightMemberSampleComparator;
import org.pepstock.jem.node.stats.LightSample;

public class OverviewPanel
extends AdminPanel
implements ResizeCapable {
    private PieChart chart = new PieChart();
    private TableContainer<LightMemberSample> gfs = new TableContainer<LightMemberSample>(new GfsTable());
    private ScrollPanel scroller = new ScrollPanel(this.gfs);
    private LinkedList<Data> mapData = new LinkedList();
    private VerticalPanel entriesPanel = new VerticalPanel();

    public OverviewPanel() {
        this.add((Widget)this.entriesPanel);
        this.add((Widget)this.scroller);
    }

    public void load() {
        this.mapData.clear();
        LightMemberSample msample = (LightMemberSample)Instances.getLastSample().getMembers().iterator().next();
        if (msample != null) {
            long tot = msample.getGfsFree() + msample.getGfsUsed();
            Data dataFree = new Data();
            dataFree.setKey("Free");
            dataFree.setValue(msample.getGfsFree());
            dataFree.setPercent((double)msample.getGfsFree() / (double)tot);
            Data dataUsed = new Data();
            dataUsed.setKey("Used");
            dataUsed.setValue(msample.getGfsUsed());
            dataUsed.setPercent((double)msample.getGfsUsed() / (double)tot);
            this.mapData.addFirst(dataFree);
            this.mapData.addLast(dataUsed);
        }
        ArrayList<LightMemberSample> list = new ArrayList<LightMemberSample>();
        for (LightSample sample : Instances.getSamples()) {
            for (LightMemberSample membersample : sample.getMembers()) {
                if (!membersample.getMemberKey().equalsIgnoreCase(msample.getMemberKey())) continue;
                list.add(membersample);
            }
        }
        Collections.sort(list, new LightMemberSampleComparator());
        this.gfs.getUnderlyingTable().setRowData(list);
        this.loadChart();
    }

    private void loadChart() {
        this.chart.setData(this.mapData);
        if (this.entriesPanel.getWidgetCount() == 0) {
            this.entriesPanel.add(this.chart.asWidget());
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int chartWidth = this.getWidth();
        this.chart.setWidth(chartWidth);
        this.chart.setHeight(240);
        int height = this.getHeight() - 240;
        height = Math.max(height, 1);
        this.scroller.setHeight(Sizes.toString(height));
        this.scroller.setWidth(Sizes.toString(this.getWidth()));
    }
}

