/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.commons;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.editor.Editor;
import org.pepstock.jem.gwt.client.editor.actions.Discard;
import org.pepstock.jem.gwt.client.editor.actions.Indent;
import org.pepstock.jem.gwt.client.editor.actions.SelectAll;
import org.pepstock.jem.gwt.client.editor.modifiers.XmlModifier;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminEditor;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.ConfigurationFile;

public class XmlConfigEditor
extends XmlModifier
implements AdminEditor {
    private static final Image imgSaveDisabled = new Image(Images.INSTANCE.edit_save_disabled());
    private static final Image imgSave = new Image(Images.INSTANCE.edit_save());
    private final Loading loading = new Loading();
    private String editType = null;
    private String description = null;
    private ConfigurationFile configurationFile = null;
    private MenuItem save = null;

    public XmlConfigEditor(String id, String editType, String description) {
        super(id);
        this.editType = editType;
        this.description = description;
    }

    public ConfigurationFile getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setEditorAttributes(Editor editor) {
        super.setEditorAttributes(editor);
        if (this.save != null) {
            this.onChange(false);
        }
    }

    @Override
    public void setMenuItems(MenuBar menu) {
        Discard discard = new Discard(this);
        Indent indent = new Indent(this);
        SelectAll selectAll = new SelectAll(this);
        Image imgSelectAll = new Image(Images.INSTANCE.edit_check());
        imgSelectAll.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        MenuItem check = new MenuItem(imgSelectAll + " Check", true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                if (XmlConfigEditor.this.getEditor().getText().trim().length() > 0) {
                    XmlConfigEditor.this.check();
                } else {
                    AlertMessageBox alert = new AlertMessageBox(1, "Unable to check XML content!", "XML content of " + XmlConfigEditor.this.getDescription() + " is empty. Check is not allowed!");
                    alert.open();
                }
            }
        });
        check.getElement().getStyle().setFontWeight(Style.FontWeight.NORMAL);
        menu.addItem(selectAll.getItem());
        menu.addItem(indent.getItem());
        menu.addItem(check);
        this.save = new MenuItem(imgSaveDisabled + " Save", true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                if (XmlConfigEditor.this.getEditor().getText().trim().length() > 0) {
                    XmlConfigEditor.this.configurationFile.setContent(XmlConfigEditor.this.getEditor().getText());
                    XmlConfigEditor.this.save();
                } else {
                    AlertMessageBox alert = new AlertMessageBox(1, "Unable to check XML content!", "XML content of " + XmlConfigEditor.this.getDescription() + " is empty. Check is not allowed!");
                    alert.open();
                }
            }
        });
        this.save.getElement().getStyle().setFontWeight(Style.FontWeight.NORMAL);
        this.onChange(false);
        menu.addSeparator();
        menu.addItem(discard.getItem());
        menu.addItem(this.save);
    }

    @Override
    public void onChange(boolean changed) {
        this.save.setEnabled(changed);
        if (changed) {
            this.save.setHTML(imgSave + " Save");
            this.save.getElement().getStyle().setColor("#000");
        } else {
            this.save.setHTML(imgSaveDisabled + " Save");
            this.save.getElement().getStyle().setColor("#ccc");
        }
    }

    private void check() {
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.checkConfigFile(XmlConfigEditor.this.getEditor().getText(), XmlConfigEditor.this.editType, (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                        AlertMessageBox alert = new AlertMessageBox(0, "Content checked!", XmlConfigEditor.this.getDescription() + " has been correctly checked.");
                        alert.open();
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Content check error!", XmlConfigEditor.this.getDescription() + ": " + caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        XmlConfigEditor.this.loading.stopProcessing();
                    }
                });
            }
        });
    }

    public void save() {
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.saveEnvConfigFile(XmlConfigEditor.this.getConfigurationFile(), XmlConfigEditor.this.editType, (AsyncCallback<ConfigurationFile>)new ServiceAsyncCallback<ConfigurationFile>(){

                    @Override
                    public void onJemSuccess(ConfigurationFile result) {
                        XmlConfigEditor.this.setConfigurationFile(result);
                        XmlConfigEditor.this.setContent(result.getContent());
                        XmlConfigEditor.this.setChanged(false);
                        AlertMessageBox alert = new AlertMessageBox(0, "Content saved!", XmlConfigEditor.this.getDescription() + " has been correctly saved.");
                        alert.open();
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Content save error!", XmlConfigEditor.this.getDescription() + ": " + caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        XmlConfigEditor.this.loading.stopProcessing();
                    }
                });
            }
        });
    }

    static {
        imgSaveDisabled.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        imgSave.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
    }
}

