/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.commons;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedList;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.panels.administration.commons.BarElement;

public class LinkButtonBar
extends FlowPanel {
    private LinkedList<Anchor> anchors = new LinkedList();
    private InspectListener<Integer> listener = null;
    private Anchor selected = null;

    public LinkButtonBar(BarElement ... elements) {
        this.addStyleName(Styles.INSTANCE.linkButtonBarStyle().bar());
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i].getLabel() == null) continue;
                Anchor anchorElement = new Anchor(elements[i].getLabel());
                anchorElement.addClickHandler((ClickHandler)new AnchorClickHandler(elements[i]));
                anchorElement.setStyleName(Styles.INSTANCE.linkButtonBarStyle().button());
                if (i == 0) {
                    anchorElement.setStyleName(Styles.INSTANCE.linkButtonBarStyle().selectedButton());
                    this.selected = anchorElement;
                }
                this.add((Widget)anchorElement);
                this.anchors.add(anchorElement);
            }
        }
    }

    public InspectListener<Integer> getListener() {
        return this.listener;
    }

    public void setListener(InspectListener<Integer> listener) {
        this.listener = listener;
    }

    private void resetColor(BarElement element) {
        if (this.selected != null) {
            this.selected.setStyleName(Styles.INSTANCE.linkButtonBarStyle().button());
        }
        if (!this.anchors.isEmpty()) {
            if (element.getValue() == BarElement.BACK.getValue()) {
                Anchor backElement = this.anchors.getLast();
                backElement.setStyleName(Styles.INSTANCE.linkButtonBarStyle().button());
                Anchor firstElement = this.anchors.getFirst();
                firstElement.setStyleName(Styles.INSTANCE.linkButtonBarStyle().selectedButton());
                this.selected = firstElement;
            } else {
                for (Anchor anchor : this.anchors) {
                    String anchorText = anchor.getText();
                    if (!anchorText.equalsIgnoreCase(element.getLabel())) continue;
                    anchor.setStyleName(Styles.INSTANCE.linkButtonBarStyle().selectedButton());
                    this.selected = anchor;
                }
            }
        }
    }

    static {
        Styles.INSTANCE.linkButtonBarStyle().ensureInjected();
    }

    class AnchorClickHandler
    implements ClickHandler {
        private BarElement element = null;

        AnchorClickHandler(BarElement element) {
            this.element = element;
        }

        public void onClick(ClickEvent event) {
            LinkButtonBar.this.resetColor(this.element);
            if (LinkButtonBar.this.listener != null) {
                LinkButtonBar.this.listener.inspect(this.element.getValue());
            }
        }
    }
}

