/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.clusterconfig;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminEditor;
import org.pepstock.jem.gwt.client.panels.administration.commons.EditorContainer;
import org.pepstock.jem.gwt.client.panels.administration.commons.XmlConfigEditor;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.ConfigurationFile;

public class ConfigPanel
extends VerticalPanel
implements ResizeCapable {
    private static final String JEM_ID = "jemEnvEditorID";
    private static final String HAZELCAST_ID = "hazelcastEditorID";
    private final Loading loading = new Loading();
    private TabPanel tabPanel = new TabPanel();
    private XmlConfigEditor envConfig = new XmlConfigEditor("jemEnvEditorID", "jem.env", "JEM environment configuration");
    private XmlConfigEditor hazelcast = new XmlConfigEditor("hazelcastEditorID", "hazelcast.config", "Hazelcast configuration");
    private EditorContainer editorContainer = new EditorContainer();

    public ConfigPanel() {
        this.editorContainer.add((Widget)this.tabPanel);
        this.editorContainer.setEditors(new AdminEditor[]{this.envConfig, this.hazelcast});
    }

    public void load() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if (this.tabPanel.getWidgetCount() == 0) {
            this.tabPanel.add((Widget)this.envConfig, "Environment");
            this.tabPanel.add((Widget)this.hazelcast, "Hazelcast");
            this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

                public void onSelection(SelectionEvent<Integer> event) {
                    if (!ConfigPanel.this.tabPanel.isVisible()) {
                        ConfigPanel.this.tabPanel.setVisible(true);
                    }
                    if ((Integer)event.getSelectedItem() == 0) {
                        if (!ConfigPanel.this.envConfig.isChanged()) {
                            ConfigPanel.this.inspect((Integer)event.getSelectedItem());
                        }
                    } else if (!ConfigPanel.this.hazelcast.isChanged()) {
                        ConfigPanel.this.inspect((Integer)event.getSelectedItem());
                    }
                }
            });
        }
        this.envConfig.setChanged(false);
        this.hazelcast.setChanged(false);
        this.editorContainer.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                ConfigPanel.this.editorContainer.setPopupPosition(ConfigPanel.this.getAbsoluteLeft(), ConfigPanel.this.getAbsoluteTop());
            }
        });
        this.tabPanel.selectTab(0, true);
    }

    private void inspect(final int what) {
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.getEnvConfigFile(what == 0 ? "jem.env" : "hazelcast.config", (AsyncCallback<ConfigurationFile>)new ServiceAsyncCallback<ConfigurationFile>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        String description = what == 0 ? ConfigPanel.this.envConfig.getDescription() : ConfigPanel.this.hazelcast.getDescription();
                        AlertMessageBox alert = new AlertMessageBox(2, "Get CONFIG file error!", description + ": " + caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(ConfigurationFile result) {
                        if (result != null) {
                            if (what == 0) {
                                ConfigPanel.this.envConfig.setConfigurationFile(result);
                                ConfigPanel.this.envConfig.setContent(result.getContent());
                                ConfigPanel.this.envConfig.startEditor();
                            } else {
                                ConfigPanel.this.hazelcast.setConfigurationFile(result);
                                ConfigPanel.this.hazelcast.setContent(result.getContent());
                                ConfigPanel.this.hazelcast.startEditor();
                            }
                        } else {
                            String description = what == 0 ? ConfigPanel.this.envConfig.getDescription() : ConfigPanel.this.hazelcast.getDescription();
                            AlertMessageBox alert = new AlertMessageBox(2, "Get CONFIG file null!", "The result, while retrieving " + description + " file, is null,");
                            alert.open();
                        }
                    }

                    @Override
                    public void onJemExecuted() {
                        ConfigPanel.this.loading.stopProcessing();
                    }
                });
            }
        });
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        this.tabPanel.setSize(Sizes.toString(availableWidth), Sizes.toString(availableHeight));
        int syntaxHighlighterHeight = availableHeight - 33 - 4 - 2 - 1;
        int syntaxHighlighterWidth = availableWidth - 4 - 4 - 2 - 2;
        this.envConfig.onResize(syntaxHighlighterWidth, syntaxHighlighterHeight);
        this.hazelcast.onResize(syntaxHighlighterWidth, syntaxHighlighterHeight);
        if (this.editorContainer.isShowing()) {
            this.editorContainer.setPopupPosition(this.getAbsoluteLeft(), this.getAbsoluteTop());
        }
    }
}

