/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.certificates;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Collection;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.events.EventBus;
import org.pepstock.jem.gwt.client.events.FilterEvent;
import org.pepstock.jem.gwt.client.events.FilterEventHandler;
import org.pepstock.jem.gwt.client.panels.administration.certificates.CertificateEntriesTable;
import org.pepstock.jem.gwt.client.panels.administration.certificates.CertificateEntryActions;
import org.pepstock.jem.gwt.client.panels.administration.certificates.CertificateEntrySearcher;
import org.pepstock.jem.gwt.client.panels.components.BasePanel;
import org.pepstock.jem.gwt.client.panels.components.CommandPanel;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.gwt.client.security.ClientPermissions;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.security.CertificateEntry;

public class CertificatesTableContainerPanel
extends BasePanel<CertificateEntry>
implements SearchListener {
    private final Loading loading = new Loading();

    public CertificatesTableContainerPanel() {
        super(new TableContainer<CertificateEntry>(new CertificateEntriesTable()), new CommandPanel<CertificateEntry>(new CertificateEntrySearcher(), new CertificateEntryActions()));
        this.getCommandPanel().getSearcher().setSearchListener(this);
        this.getCommandPanel().getActions().setUnderlyingTable(this.getTableContainer().getUnderlyingTable());
        EventBus.INSTANCE.addHandler(FilterEvent.TYPE, (EventHandler)((FilterEventHandler)((Object)this.getCommandPanel().getSearcher())));
    }

    @Override
    public void search(final String filter) {
        if (ClientPermissions.isAuthorized("certificates", "certificates:read")) {
            this.getCommandPanel().getSearcher().setEnabled(false);
            this.loading.startProcessing();
            Scheduler scheduler = Scheduler.get();
            scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    Services.CERTIFICATES_MANAGER.getCertificates(filter, (AsyncCallback<Collection<CertificateEntry>>)new ServiceAsyncCallback<Collection<CertificateEntry>>(){

                        @Override
                        public void onJemFailure(Throwable caught) {
                            AlertMessageBox alert = new AlertMessageBox(2, "Search error!", caught.getMessage());
                            alert.open();
                            CertificatesTableContainerPanel.this.getCommandPanel().getSearcher().setFirstSearch(true);
                        }

                        @Override
                        public void onJemSuccess(Collection<CertificateEntry> result) {
                            CertificatesTableContainerPanel.this.getTableContainer().getUnderlyingTable().setRowData(result);
                            CertificatesTableContainerPanel.this.getCommandPanel().getSearcher().setFirstSearch(false);
                        }

                        @Override
                        public void onJemExecuted() {
                            CertificatesTableContainerPanel.this.loading.stopProcessing();
                            CertificatesTableContainerPanel.this.getCommandPanel().getSearcher().setEnabled(true);
                        }
                    });
                }
            });
        }
    }
}

