/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.resources.CryptedValueAndHash;

public class SecretUtilityPanel
extends VerticalPanel
implements ResizeCapable {
    private final Loading loading = new Loading();
    private PasswordTextBox secretBox = new PasswordTextBox();
    private PasswordTextBox secretBox2 = new PasswordTextBox();
    private Label encrypt = new Label("N/A");
    private Label hash = new Label("N/A");
    private Button execButton = null;
    private ScrollPanel scrollPanel = null;

    public SecretUtilityPanel() {
        VerticalPanel container = new VerticalPanel();
        this.setSize("100%", "100%");
        this.secretBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (SecretUtilityPanel.this.secretBox.getText().length() > 0 && SecretUtilityPanel.this.secretBox2.getText().length() > 0 && SecretUtilityPanel.this.secretBox.getText().equals(SecretUtilityPanel.this.secretBox2.getText())) {
                    SecretUtilityPanel.this.execButton.setEnabled(true);
                } else {
                    SecretUtilityPanel.this.execButton.setEnabled(false);
                }
            }
        });
        this.secretBox2.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (SecretUtilityPanel.this.secretBox.getText().length() > 0 && SecretUtilityPanel.this.secretBox2.getText().length() > 0 && SecretUtilityPanel.this.secretBox.getText().equals(SecretUtilityPanel.this.secretBox2.getText())) {
                    SecretUtilityPanel.this.execButton.setEnabled(true);
                } else {
                    SecretUtilityPanel.this.execButton.setEnabled(false);
                }
            }
        });
        this.execButton = new Button("Execute", new ClickHandler(){

            public void onClick(ClickEvent event) {
                SecretUtilityPanel.this.getEncryptedSecret(SecretUtilityPanel.this.secretBox.getText());
            }
        });
        this.execButton.setEnabled(false);
        container.setSpacing(10);
        container.add((Widget)new HTML("<h2>Secret utility</h2>"));
        HorizontalPanel imageAndDescription = new HorizontalPanel();
        imageAndDescription.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        Image image = new Image(Images.INSTANCE.keys());
        HTML description = new HTML("This utility allows you to have got an encrypted secret (password and others) that you could use in your JCL.<br>This function must be use when you define a Common Resource and you want to hide the password value.<br>Calulate the value and copy & paste in your JCL.</p>");
        imageAndDescription.add((Widget)image);
        imageAndDescription.add((Widget)description);
        imageAndDescription.setCellWidth((Widget)description, "100%");
        container.add((Widget)imageAndDescription);
        FlexTable form = new FlexTable();
        form.setCellPadding(10);
        form.setHTML(0, 0, "Secret");
        form.setWidget(0, 1, (Widget)this.secretBox);
        form.setHTML(1, 0, "Secret (twice to check)");
        form.setWidget(1, 1, (Widget)this.secretBox2);
        form.setHTML(2, 0, "");
        form.setWidget(2, 1, (Widget)this.execButton);
        form.setHTML(3, 0, "Encrypted secret");
        form.setWidget(3, 1, (Widget)this.encrypt);
        form.setHTML(4, 0, "Hash secret");
        form.setWidget(4, 1, (Widget)this.hash);
        container.add((Widget)form);
        this.scrollPanel = new ScrollPanel((Widget)container);
        this.add((Widget)this.scrollPanel);
    }

    public void getEncryptedSecret(final String secret) {
        this.execButton.setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.COMMON_RESOURCES_MANAGER.getEncryptedSecret(secret, (AsyncCallback<CryptedValueAndHash>)new ServiceAsyncCallback<CryptedValueAndHash>(){

                    @Override
                    public void onJemSuccess(CryptedValueAndHash result) {
                        SecretUtilityPanel.this.encrypt.setText(result.getCryptedValue());
                        SecretUtilityPanel.this.hash.setText(result.getHash());
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Encrypt secret error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        SecretUtilityPanel.this.loading.stopProcessing();
                        SecretUtilityPanel.this.execButton.setEnabled(true);
                    }
                });
            }
        });
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        this.scrollPanel.setSize(Sizes.toString(availableWidth), Sizes.toString(availableHeight));
    }
}

