/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.NodesSearcher;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.ConfigPanel;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.NodesList;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.Separator;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.SeparatorListener;
import org.pepstock.jem.gwt.client.services.Services;

public class NodesConfigPanel
extends AdminPanel
implements SearchListener,
SeparatorListener,
ResizeCapable {
    private final Loading loading = new Loading();
    private NodesSearcher searcher = new NodesSearcher("administration.nodes.configuration");
    private HorizontalPanel secondRow = new HorizontalPanel();
    private NodesList list = new NodesList();
    private ConfigPanel config = new ConfigPanel();
    private Separator separator = new Separator();

    public NodesConfigPanel() {
        this.config.getEditorContainer().setModel(this.list.getSelectionModel());
        this.config.getEditorContainer().setSeparator(this.separator);
        this.add((Widget)this.searcher);
        this.searcher.setSearchListener(this);
        this.list.setListener(this.config);
        this.separator.setListener(this);
        this.secondRow.add((Widget)this.list);
        this.secondRow.add((Widget)this.separator);
        this.secondRow.add((Widget)this.config);
        this.config.setVisible(false);
        this.add((Widget)this.secondRow);
    }

    public void load() {
    }

    public NodesList getList() {
        return this.list;
    }

    @Override
    public void search(final String filter) {
        this.config.setVisible(false);
        this.searcher.setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.getNodes(filter, (AsyncCallback<Collection<NodeInfoBean>>)new ServiceAsyncCallback<Collection<NodeInfoBean>>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Search error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(Collection<NodeInfoBean> result) {
                        if (!NodesConfigPanel.this.separator.isOpen()) {
                            NodesConfigPanel.this.separator.setOpen(true);
                        }
                        NodesConfigPanel.this.list.setRowData(result);
                        if (result.size() == 1) {
                            NodeInfoBean node = result.iterator().next();
                            NodesConfigPanel.this.list.getSelectionModel().setSelected((Object)node, true);
                        }
                    }

                    @Override
                    public void onJemExecuted() {
                        NodesConfigPanel.this.loading.stopProcessing();
                        NodesConfigPanel.this.searcher.setEnabled(true);
                    }
                });
            }
        });
    }

    @Override
    public void changeSeparator(Boolean object) {
        if (object.booleanValue()) {
            this.list.setVisible(true);
        } else {
            this.list.setVisible(false);
        }
        this.internalResize();
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        this.internalResize();
    }

    private void internalResize() {
        int height = this.getHeight() - 44;
        if (this.separator.isOpen()) {
            this.list.setSize(Sizes.toString(250), Sizes.toString(height));
            this.list.onResize(250, height);
        }
        this.separator.setSize(Sizes.toString(6), Sizes.toString(height));
        int configWidth = this.getWidth() - (this.separator.isOpen() ? 250 : 0) - 6;
        this.config.setSize(Sizes.toString(configWidth), Sizes.toString(height));
        this.config.onResize(configWidth, height);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

