/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.grs.CommandResultPanel;
import org.pepstock.jem.gwt.client.panels.administration.grs.ResourcesSearcher;
import org.pepstock.jem.gwt.client.services.Services;

public class GrsPanel
extends AdminPanel
implements SearchListener,
ResizeCapable {
    private final Loading loading = new Loading();
    private ResourcesSearcher searcher = new ResourcesSearcher();
    private CommandResultPanel resultPanel = new CommandResultPanel();

    public GrsPanel() {
        this.add((Widget)this.searcher);
        this.searcher.setSearchListener(this);
        this.resultPanel.setVisible(false);
        this.add((Widget)this.resultPanel);
    }

    public void load() {
        this.search("*");
    }

    @Override
    public void search(final String filter) {
        this.resultPanel.setVisible(false);
        this.searcher.setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.STATS_MANAGER.displayRequestors(filter, (AsyncCallback<String>)new ServiceAsyncCallback<String>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Display command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(String result) {
                        if (result != null) {
                            GrsPanel.this.resultPanel.setResult(result);
                        } else {
                            AlertMessageBox alert = new AlertMessageBox(1, "Result empty!", "The result of dispaly requestors command is empty.");
                            alert.open();
                        }
                    }

                    @Override
                    public void onJemExecuted() {
                        GrsPanel.this.loading.stopProcessing();
                        GrsPanel.this.searcher.setEnabled(true);
                    }
                });
                GrsPanel.this.resultPanel.setVisible(true);
            }
        });
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int resultHeight = this.getHeight() - 44;
        int resultWidth = this.getWidth();
        this.resultPanel.setSize(Sizes.toString(resultWidth), Sizes.toString(resultHeight));
        this.resultPanel.onResize(resultWidth, resultHeight);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

