/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.StackLayoutPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputTree;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.JobStatus;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.components.AbstractActionsButtonPanel;
import org.pepstock.jem.gwt.client.panels.components.CommandPanel;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.gwt.client.panels.jobs.commons.JobInspector;
import org.pepstock.jem.gwt.client.panels.jobs.input.InputTable;
import org.pepstock.jem.gwt.client.panels.jobs.output.OutputTable;
import org.pepstock.jem.gwt.client.panels.jobs.routing.RoutingTable;
import org.pepstock.jem.gwt.client.panels.jobs.running.RunningTable;
import org.pepstock.jem.gwt.client.panels.status.Header;
import org.pepstock.jem.gwt.client.panels.status.JobsSearcher;
import org.pepstock.jem.gwt.client.services.Services;

public class Status
extends VerticalPanel
implements ResizeCapable,
SearchListener {
    private final Loading loading = new Loading();
    private CommandPanel<Job> commandPanel = null;
    private StackLayoutPanel stackPanel = new StackLayoutPanel(Style.Unit.PX);
    private TableContainer<Job> input = new TableContainer<Job>(new InputTable(false));
    private TableContainer<Job> running = new TableContainer<Job>(new RunningTable(false));
    private TableContainer<Job> output = new TableContainer<Job>(new OutputTable(false));
    private TableContainer<Job> routing = new TableContainer<Job>(new RoutingTable(false));

    public Status() {
        this.input.getUnderlyingTable().setInspectListener(new InspectListener<Job>(){

            @Override
            public void inspect(Job job) {
                Status.this.inspect(job, "org.pepstock.jem.input", false);
            }
        });
        this.running.getUnderlyingTable().setInspectListener(new InspectListener<Job>(){

            @Override
            public void inspect(Job job) {
                Status.this.inspect(job, "org.pepstock.jem.running", true);
            }
        });
        this.output.getUnderlyingTable().setInspectListener(new InspectListener<Job>(){

            @Override
            public void inspect(Job job) {
                Status.this.inspect(job, "org.pepstock.jem.output", true);
            }
        });
        this.routing.getUnderlyingTable().setInspectListener(new InspectListener<Job>(){

            @Override
            public void inspect(Job job) {
                Status.this.inspect(job, "org.pepstock.jem.routing", false);
            }
        });
        this.commandPanel = new CommandPanel<Job>(new JobsSearcher(), new AbstractActionsButtonPanel<Job>(){

            @Override
            protected void initButtons() {
            }
        }, 50);
        this.commandPanel.getSearcher().setSearchListener(this);
        this.stackPanel.add(this.input, this.createHeaderWidget("Input"), 30.0);
        this.stackPanel.add(this.running, this.createHeaderWidget("Running"), 30.0);
        this.stackPanel.add(this.output, this.createHeaderWidget("Output"), 30.0);
        this.stackPanel.add(this.routing, this.createHeaderWidget("Routing"), 30.0);
        this.add((Widget)this.commandPanel);
        this.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
    }

    private Widget createHeaderWidget(String text) {
        return new Header(text);
    }

    @Override
    public void search(final String jobsFilter) {
        if (this.getWidgetCount() == 1) {
            this.add((Widget)this.stackPanel);
        }
        this.commandPanel.getSearcher().setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.getJobStatus(jobsFilter, (AsyncCallback<JobStatus>)new ServiceAsyncCallback<JobStatus>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Get JobStatus error!", caught.getMessage());
                        alert.open();
                        Status.this.commandPanel.getSearcher().setFirstSearch(true);
                    }

                    @Override
                    public void onJemSuccess(JobStatus result) {
                        Status.this.commandPanel.getSearcher().setFirstSearch(false);
                        int inputIX = Status.this.changeHeader(result.getJobsInput(), "Input", 0);
                        int runningIX = Status.this.changeHeader(result.getJobsRunning(), "Running", 1);
                        int outputIX = Status.this.changeHeader(result.getJobsOutput(), "Output", 2);
                        int routingIX = Status.this.changeHeader(result.getJobsRouting(), "Routing", 3);
                        Status.this.input.getUnderlyingTable().setRowData(result.getJobsInput());
                        Status.this.running.getUnderlyingTable().setRowData(result.getJobsRunning());
                        Status.this.output.getUnderlyingTable().setRowData(result.getJobsOutput());
                        Status.this.routing.getUnderlyingTable().setRowData(result.getJobsRouting());
                        int showIndex = Math.min(Math.min(Math.min(inputIX, runningIX), outputIX), routingIX);
                        Status.this.stackPanel.showWidget(showIndex == Integer.MAX_VALUE ? 0 : showIndex);
                    }

                    @Override
                    public void onJemExecuted() {
                        Status.this.loading.stopProcessing();
                        Status.this.commandPanel.getSearcher().setEnabled(true);
                    }
                });
            }
        });
    }

    public final void inspect(final Job job, final String queueName, final boolean getOuput) {
        this.commandPanel.getSearcher().setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                if (getOuput) {
                    Services.QUEUES_MANAGER.getOutputTree(job, queueName, (AsyncCallback<OutputTree>)new ServiceAsyncCallback<OutputTree>(){

                        @Override
                        public void onJemFailure(Throwable caught) {
                            AlertMessageBox alert = new AlertMessageBox(2, "Get JCL error!", caught.getMessage());
                            alert.open();
                        }

                        @Override
                        public void onJemSuccess(OutputTree result) {
                            job.getJcl().setContent(result.getJclContent());
                            JobInspector inspector = new JobInspector(job, result);
                            inspector.setModal(true);
                            inspector.setTitle(job.getName());
                            inspector.center();
                            inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                                public void onClose(CloseEvent<PopupPanel> arg0) {
                                }
                            });
                        }

                        @Override
                        public void onJemExecuted() {
                            Status.this.loading.stopProcessing();
                            Status.this.commandPanel.getSearcher().setEnabled(true);
                        }
                    });
                } else {
                    Services.QUEUES_MANAGER.getJcl(job, queueName, (AsyncCallback<String>)new ServiceAsyncCallback<String>(){

                        @Override
                        public void onJemFailure(Throwable caught) {
                            AlertMessageBox alert = new AlertMessageBox(2, "Get JCL error!", caught.getMessage());
                            alert.open();
                        }

                        @Override
                        public void onJemSuccess(String result) {
                            job.getJcl().setContent(result);
                            JobInspector inspector = new JobInspector(job);
                            inspector.setModal(true);
                            inspector.setTitle(job.getName());
                            inspector.center();
                            inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                                public void onClose(CloseEvent<PopupPanel> arg0) {
                                }
                            });
                        }

                        @Override
                        public void onJemExecuted() {
                            Status.this.loading.stopProcessing();
                            Status.this.commandPanel.getSearcher().setEnabled(true);
                        }
                    });
                }
            }
        });
    }

    private int changeHeader(Collection<Job> collection, String queue, int index) {
        Header header = (Header)this.stackPanel.getHeaderWidget(index);
        if (collection != null) {
            header.setCount(collection.size());
            if (collection.size() > 0) {
                return index;
            }
        } else {
            header.setCount(0);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        int height = availableHeight - 44;
        this.stackPanel.setPixelSize(availableWidth, height);
    }
}

