/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.PopupPanel;
import java.util.Collection;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputTree;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.UpdateListener;
import org.pepstock.jem.gwt.client.events.EventBus;
import org.pepstock.jem.gwt.client.events.FilterEvent;
import org.pepstock.jem.gwt.client.events.FilterEventHandler;
import org.pepstock.jem.gwt.client.panels.components.BasePanel;
import org.pepstock.jem.gwt.client.panels.components.CommandPanel;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.gwt.client.panels.jobs.commons.JobInspector;
import org.pepstock.jem.gwt.client.panels.jobs.commons.JobsSearcher;
import org.pepstock.jem.gwt.client.panels.jobs.running.RunningActions;
import org.pepstock.jem.gwt.client.panels.jobs.running.RunningTable;
import org.pepstock.jem.gwt.client.services.Services;

public class Running
extends BasePanel<Job>
implements SearchListener,
UpdateListener<Job> {
    private final Loading loading = new Loading();

    public Running() {
        super(new TableContainer<Job>(new RunningTable(true)), new CommandPanel<Job>(new JobsSearcher("job.search.running"), new RunningActions()));
        this.getCommandPanel().getSearcher().setSearchListener(this);
        this.getCommandPanel().getActions().setUnderlyingTable(this.getTableContainer().getUnderlyingTable());
        this.getTableContainer().getUnderlyingTable().setInspectListener(this);
        EventBus.INSTANCE.addHandler(FilterEvent.TYPE, (EventHandler)((FilterEventHandler)((Object)this.getCommandPanel().getSearcher())));
    }

    @Override
    public void search(final String jobsFilter) {
        this.getCommandPanel().getSearcher().setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.getRunningQueue(jobsFilter, (AsyncCallback<Collection<Job>>)new ServiceAsyncCallback<Collection<Job>>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Search error!", caught.getMessage());
                        alert.open();
                        Running.this.getCommandPanel().getSearcher().setFirstSearch(true);
                    }

                    @Override
                    public void onJemSuccess(Collection<Job> result) {
                        Running.this.getTableContainer().getUnderlyingTable().setRowData(result);
                        Running.this.getCommandPanel().getSearcher().setFirstSearch(false);
                    }

                    @Override
                    public void onJemExecuted() {
                        Running.this.loading.stopProcessing();
                        Running.this.getCommandPanel().getSearcher().setEnabled(true);
                    }
                });
            }
        });
    }

    @Override
    public void inspect(final Job job) {
        this.getCommandPanel().getSearcher().setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.getOutputTree(job, "org.pepstock.jem.running", (AsyncCallback<OutputTree>)new ServiceAsyncCallback<OutputTree>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Get OUTPUT error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(OutputTree result) {
                        job.getJcl().setContent(result.getJclContent());
                        JobInspector inspector = new JobInspector(job, result);
                        inspector.setModal(true);
                        inspector.setTitle(job.getName());
                        inspector.center();
                        inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                            public void onClose(CloseEvent<PopupPanel> arg0) {
                                Running.this.getCommandPanel().getSearcher().refresh();
                            }
                        });
                    }

                    @Override
                    public void onJemExecuted() {
                        Running.this.loading.stopProcessing();
                        Running.this.getCommandPanel().getSearcher().setEnabled(true);
                    }
                });
            }
        });
    }

    @Override
    public void update(Job object) {
    }
}

