/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.editor;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.editor.Editor;
import org.pepstock.jem.gwt.client.editor.EditorChangeHandler;
import org.pepstock.jem.gwt.client.editor.FontSize;
import org.pepstock.jem.gwt.client.editor.SyntaxHighlighter;
import org.pepstock.jem.gwt.client.editor.Theme;
import org.pepstock.jem.gwt.client.events.EventBus;
import org.pepstock.jem.gwt.client.events.FontSizeEvent;
import org.pepstock.jem.gwt.client.events.FontSizeEventHandler;
import org.pepstock.jem.gwt.client.security.CurrentUser;

public abstract class AbstractSyntaxHighlighter
extends VerticalPanel
implements SyntaxHighlighter {
    private String content = null;
    private Editor editor = null;
    private boolean editorStarted = false;
    private MenuBar menu = new MenuBar();
    private MenuItem selectedFontItem = null;
    private boolean changed = false;
    private boolean readOnly = false;
    private MenuItem small = null;
    private MenuItem medium = null;
    private MenuItem large = null;
    private MenuItem extraLarge = null;
    private HandlerRegistration eventRegistration = null;
    private FontSize currentFontSize = null;

    public AbstractSyntaxHighlighter() {
        this(null);
    }

    public AbstractSyntaxHighlighter(String id) {
        this.menu.addStyleName(Styles.INSTANCE.common().editMenuBar());
        this.menu.setHeight(Sizes.toString(33));
        this.menu.setAnimationEnabled(true);
        this.add((Widget)this.menu);
        this.editor = id == null ? new Editor() : new Editor(id);
        this.add(this.editor);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public boolean isEditorStarted() {
        return this.editorStarted;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
        if (this.editorStarted) {
            this.editor.setText(content);
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.editor.setReadOnly(readOnly);
    }

    @Override
    public void startEditor() {
        if (!this.editorStarted) {
            this.editor.start();
            this.editor.setTheme(Theme.JEM);
            this.setEditorAttributes(this.editor);
            this.editor.setShowPrintMargin(false);
            this.editor.setText(this.content);
            this.editorStarted = true;
            this.editor.addOnChangeHandler(new EditorChangeHandler(){

                @Override
                public void invokeAceCallback(JavaScriptObject obj) {
                    if (AbstractSyntaxHighlighter.this.getContent() != null) {
                        AbstractSyntaxHighlighter.this.changed = !AbstractSyntaxHighlighter.this.getContent().equalsIgnoreCase(AbstractSyntaxHighlighter.this.getEditor().getText());
                    } else {
                        AbstractSyntaxHighlighter.this.changed = false;
                    }
                    AbstractSyntaxHighlighter.this.onChange(AbstractSyntaxHighlighter.this.changed);
                }
            });
            String pref = CurrentUser.getInstance().getStringPreference("job.edit.fontsize");
            if (pref == null) {
                pref = FontSize.SMALL.getCssValue();
            }
            MenuBar fontSizeMenu = new MenuBar(true);
            this.small = this.createMenuItem(FontSize.SMALL, pref);
            this.medium = this.createMenuItem(FontSize.MEDIUM, pref);
            this.large = this.createMenuItem(FontSize.LARGE, pref);
            this.extraLarge = this.createMenuItem(FontSize.EXTRA_LARGE, pref);
            fontSizeMenu.addItem(this.small);
            fontSizeMenu.addItem(this.medium);
            fontSizeMenu.addItem(this.large);
            fontSizeMenu.addItem(this.extraLarge);
            if (this.content == null) {
                this.small.setEnabled(false);
                this.medium.setEnabled(false);
                this.large.setEnabled(false);
                this.extraLarge.setEnabled(false);
            }
            Image imgFontSize = new Image(Images.INSTANCE.edit_font_size());
            imgFontSize.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
            MenuItem fontSizeMenuItem = new MenuItem(imgFontSize + "  Size", true, fontSizeMenu);
            fontSizeMenuItem.getElement().getStyle().setFontWeight(Style.FontWeight.NORMAL);
            this.menu.addItem(fontSizeMenuItem);
            this.setMenuItems(this.menu);
            this.eventRegistration = EventBus.INSTANCE.addHandler(FontSizeEvent.TYPE, (EventHandler)new FontSizeEventHandler(){

                @Override
                public void onChange(FontSizeEvent event) {
                    if (AbstractSyntaxHighlighter.this.isEditorStarted()) {
                        FontSize fontsize = event.getFontSize();
                        AbstractSyntaxHighlighter.this.currentFontSize = fontsize;
                        AbstractSyntaxHighlighter.this.editor.setFontSize(fontsize.getCssValue());
                        AbstractSyntaxHighlighter.this.selectedFontItem.setEnabled(true);
                        AbstractSyntaxHighlighter.this.selectedFontItem.removeStyleName(Styles.INSTANCE.common().editMenuItemDisabled());
                        MenuItem item = null;
                        if (fontsize.getName().equals(FontSize.SMALL.getName())) {
                            item = AbstractSyntaxHighlighter.this.small;
                        } else if (fontsize.getName().equals(FontSize.MEDIUM.getName())) {
                            item = AbstractSyntaxHighlighter.this.medium;
                        } else if (fontsize.getName().equals(FontSize.LARGE.getName())) {
                            item = AbstractSyntaxHighlighter.this.large;
                        } else if (fontsize.getName().equals(FontSize.EXTRA_LARGE.getName())) {
                            item = AbstractSyntaxHighlighter.this.extraLarge;
                        }
                        item.setEnabled(false);
                        item.addStyleName(Styles.INSTANCE.common().editMenuItemDisabled());
                        AbstractSyntaxHighlighter.this.selectedFontItem = item;
                    }
                }
            });
        } else {
            this.setEditorAttributes(this.editor);
            this.editor.setFontSize(this.currentFontSize.getCssValue());
        }
    }

    public abstract void setEditorAttributes(Editor var1);

    public abstract void setMenuItems(MenuBar var1);

    private MenuItem createMenuItem(final FontSize fontsize, String preference) {
        SafeHtmlBuilder builder = new SafeHtmlBuilder();
        builder.appendHtmlConstant("<div style='font-size: " + fontsize.getCssValue() + ";'>" + fontsize.getName() + "</div>");
        MenuItem item = new MenuItem(builder.toSafeHtml());
        item.setScheduledCommand((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                CurrentUser.getInstance().setStringPreference("job.edit.fontsize", fontsize.getCssValue());
                FontSizeEvent event = new FontSizeEvent(fontsize);
                EventBus.INSTANCE.fireEvent((GwtEvent)event);
            }
        });
        if (preference.equalsIgnoreCase(fontsize.getCssValue())) {
            this.selectedFontItem = item;
            item.setEnabled(false);
            item.addStyleName(Styles.INSTANCE.common().editMenuItemDisabled());
            this.editor.setFontSize(fontsize.getCssValue());
            this.currentFontSize = fontsize;
        }
        return item;
    }

    @Override
    public void destroyEditor() {
        if (this.editorStarted) {
            this.editor.destroy();
            if (this.eventRegistration != null) {
                this.eventRegistration.removeHandler();
            }
        }
    }

    public void onChange(boolean changed) {
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        this.menu.setWidth(Sizes.toString(availableWidth));
        this.editor.setWidth(Sizes.toString(availableWidth));
        this.editor.setHeight(Sizes.toString(availableHeight - 33 - 1));
        if (this.isEditorStarted()) {
            this.editor.onResize();
        }
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

