/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import java.util.Date;
import org.pepstock.jem.gwt.client.commons.SharedObjects;

public class TimeDisplayUtils {
    public static final int NORMAL = 0;
    public static final int VERBOSE = 1;

    private TimeDisplayUtils() {
    }

    public static String getReadableTimeDiff(long startMillis) {
        return TimeDisplayUtils.getReadableTimeDiff(startMillis, 0);
    }

    public static String getReadableTimeDiff(long startMillis, int display) {
        return TimeDisplayUtils.getReadableTimeDiff(System.currentTimeMillis(), startMillis, display);
    }

    public static String getReadableTimeDiff(Date end, Date start) {
        return TimeDisplayUtils.getReadableTimeDiff(end, start, 0);
    }

    public static String getReadableTimeDiff(Date end, Date start, int display) {
        return TimeDisplayUtils.getReadableTimeDiff(end.getTime(), start.getTime(), display);
    }

    public static String getReadableTimeDiff(Date start) {
        return TimeDisplayUtils.getReadableTimeDiff(start, 0);
    }

    public static String getReadableTimeDiff(Date start, int display) {
        return TimeDisplayUtils.getReadableTimeDiff(System.currentTimeMillis(), start.getTime(), display);
    }

    public static String getReadableTimeDiff(long endMillis, long startMillis, int display) {
        long diff = endMillis - startMillis - SharedObjects.getClusterDifferenceTime();
        long seconds = 0L;
        long minutes = 0L;
        long hours = 0L;
        long days = 0L;
        if (diff > 86400000L) {
            days = diff / 86400000L;
            diff -= days * 86400000L;
        }
        if (diff > 3600000L) {
            hours = diff / 3600000L;
            diff -= hours * 3600000L;
        }
        if (diff > 60000L) {
            minutes = diff / 60000L;
            diff -= minutes * 60000L;
        }
        seconds = diff / 1000L;
        return TimeDisplayUtils.getText(days, hours, minutes, seconds, display);
    }

    private static String getText(long days, long hours, long minutes, long seconds, int display) {
        StringBuffer sb = new StringBuffer();
        if (display == 1) {
            if (days != 0L) {
                sb.append(days).append(" d ");
                sb.append(hours).append(" h ");
                sb.append(minutes).append(" m");
            } else if (hours != 0L) {
                sb.append(hours).append(" h ");
                sb.append(minutes).append(" m");
            } else {
                sb.append(minutes).append(" m");
            }
        } else if (days != 0L) {
            sb.append(days).append(".");
            sb.append(hours < 10L ? "0" + hours : Long.valueOf(hours)).append(":");
            sb.append(minutes < 10L ? "0" + minutes : Long.valueOf(minutes)).append(":");
            sb.append(seconds < 10L ? "0" + seconds : Long.valueOf(seconds));
        } else if (hours != 0L) {
            sb.append(hours).append(":");
            sb.append(minutes < 10L ? "0" + minutes : Long.valueOf(minutes)).append(":");
            sb.append(seconds < 10L ? "0" + seconds : Long.valueOf(seconds));
        } else if (minutes != 0L) {
            sb.append(minutes).append(":");
            sb.append(seconds < 10L ? "0" + seconds : Long.valueOf(seconds));
        } else {
            sb.append(seconds).append(" s");
        }
        return sb.toString();
    }
}

