/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.user.client.Window;
import java.util.HashSet;
import java.util.Set;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.FilterInputPanel;
import org.pepstock.jem.gwt.client.commons.TextFilterableHeader;

public class TextFilteredCell
extends TextCell {
    private static final int CURSOR_SIZE = 20;
    private static final int X_DELTA = 275;
    private TextFilterableHeader header = null;
    private FilterInputPanel filterInputPanel = null;
    private String helpPattern = null;
    private boolean showable = true;

    public TextFilteredCell() {
        this((String)null);
    }

    public TextFilteredCell(String helpPattern) {
        this.helpPattern = helpPattern;
    }

    public TextFilteredCell(SafeHtmlRenderer<String> renderer) {
        this(renderer, null);
    }

    public TextFilteredCell(SafeHtmlRenderer<String> renderer, String helpPattern) {
        super(renderer);
        this.helpPattern = helpPattern;
    }

    public TextFilterableHeader getHeader() {
        return this.header;
    }

    public void setHeader(TextFilterableHeader header) {
        this.header = header;
    }

    public boolean isShowable() {
        return this.showable;
    }

    public void setShowable(boolean showable) {
        this.showable = showable;
    }

    public Set<String> getConsumedEvents() {
        HashSet<String> consumedEvents = super.getConsumedEvents();
        if (consumedEvents == null) {
            consumedEvents = new HashSet<String>();
        }
        consumedEvents.add("mouseover");
        consumedEvents.add("mouseout");
        consumedEvents.add("click");
        return consumedEvents;
    }

    public void onBrowserEvent(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        super.onBrowserEvent(context, parent, (Object)value, event, valueUpdater);
        try {
            if ("mouseover".equals(event.getType())) {
                if (this.showable) {
                    this.showFilterPanel(event);
                    this.showable = false;
                }
            } else if ("mouseout".equals(event.getType())) {
                this.hideFilterPanel(event);
                this.showable = true;
            } else if ("click".equals(event.getType())) {
                this.hideFilterPanel(event);
                this.showable = false;
            }
        }
        catch (Exception e) {
            new AlertMessageBox(2, "UI Error!", "An error has occoured while displaying FilterPopupPanel").show();
        }
    }

    protected void showFilterPanel(NativeEvent event) {
        this.filterInputPanel = new FilterInputPanel(this.header.getFilterName(), this.helpPattern);
        int x = event.getClientX() + 20;
        int y = event.getClientY() - 20;
        if (Window.getClientWidth() - x <= 275) {
            x -= 275;
        }
        this.filterInputPanel.setPopupPosition(x, y);
        this.filterInputPanel.startProcessing();
    }

    protected void hideFilterPanel(NativeEvent event) {
        if (this.filterInputPanel != null) {
            this.filterInputPanel.stopProcessing();
        }
    }
}

