/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedList;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.SearcherTextBox;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.security.CurrentUser;

public abstract class SearcherWidget
extends HorizontalPanel {
    public static final String DEFAULT_INITIAL_FILTER_VALUE = "*";
    private final Button search = new Button("Search");
    private SearcherTextBox textBox = new SearcherTextBox();
    private boolean firstSearch = true;
    private boolean enabled = true;
    private String preferenceKey = null;

    public SearcherWidget(String labelValue) {
        this(labelValue, 0, DEFAULT_INITIAL_FILTER_VALUE);
    }

    public SearcherWidget(String labelValue, String initialValue) {
        this(labelValue, 0, initialValue);
    }

    public SearcherWidget(String labelValue, int minChar) {
        this(labelValue, minChar, DEFAULT_INITIAL_FILTER_VALUE);
    }

    public SearcherWidget(String labelValue, int minChar, String initialValue) {
        this(labelValue, minChar, initialValue, null);
    }

    public SearcherWidget(String labelValue, final int minChar, String initialValue, String preferenceKey) {
        this.preferenceKey = preferenceKey;
        this.setSize("100%", Sizes.toString(44));
        this.addStyleName(Styles.INSTANCE.common().noWrap());
        this.setSpacing(4);
        this.setHorizontalAlignment(ALIGN_LEFT);
        this.setVerticalAlignment(ALIGN_MIDDLE);
        Label label = new Label(labelValue);
        if (initialValue != null) {
            this.textBox.setText(initialValue);
        }
        if (preferenceKey != null) {
            this.textBox.setPreferenceKey(preferenceKey);
            LinkedList<String> list = CurrentUser.getInstance().getListPreference(preferenceKey);
            if (list != null && !list.isEmpty()) {
                this.textBox.setText(list.getFirst());
            }
        }
        this.search.addStyleName(Styles.INSTANCE.common().defaultActionButton());
        if (this.textBox.getText().length() <= minChar) {
            this.search.setEnabled(false);
        } else {
            this.search.setEnabled(true);
        }
        this.textBox.setSearchButton(this.search);
        this.textBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (SearcherWidget.this.textBox.getText().length() <= minChar) {
                    SearcherWidget.this.search.setEnabled(false);
                } else {
                    SearcherWidget.this.search.setEnabled(true);
                }
                SearcherWidget.this.textBox.hide();
            }
        });
        this.textBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if (event.getNativeEvent().getKeyCode() == 13 && SearcherWidget.this.search.isEnabled()) {
                    SearcherWidget.this.search.click();
                    SearcherWidget.this.savePreference();
                }
            }
        });
        this.search.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearcherWidget.this.textBox.hide();
                SearcherWidget.this.onSearch(SearcherWidget.this.textBox.getText());
                SearcherWidget.this.savePreference();
            }
        });
        this.add((Widget)label);
        this.add((Widget)this.textBox);
        this.add((Widget)this.search);
        this.setCellWidth((Widget)this.textBox, "100%");
    }

    private void savePreference() {
        if (this.getPreferenceKey() != null && this.textBox.getText().trim().length() > 0) {
            LinkedList<String> list = CurrentUser.getInstance().getListPreference(this.getPreferenceKey());
            if (list == null) {
                list = new LinkedList();
                CurrentUser.getInstance().setListPreference(this.getPreferenceKey(), list);
            }
            if (!list.contains(this.textBox.getText())) {
                list.addFirst(this.textBox.getText());
                if (list.size() > 10) {
                    list.removeLast();
                }
                CurrentUser.getInstance().setLastUpdateTime();
            } else {
                list.remove(this.textBox.getText());
                list.addFirst(this.textBox.getText());
                CurrentUser.getInstance().setLastUpdateTime();
            }
        }
    }

    public boolean isFirstSearch() {
        return this.firstSearch;
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
    }

    public void setFirstSearch(boolean firstSearch) {
        this.firstSearch = firstSearch;
    }

    public abstract void onSearch(String var1);

    public void refresh() {
        this.onSearch(this.textBox.getText());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.textBox.setReadOnly(!enabled);
        this.search.setEnabled(enabled);
    }

    public void setSearchText(String textToSearch) {
        this.textBox.setText(textToSearch);
    }

    public String getSearchText() {
        return this.textBox.getText();
    }

    public void setFocusOnTextBox() {
        this.textBox.setFocus(true);
    }

    public void setFocusOnButton() {
        this.search.setFocus(true);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

