/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.TextBox;
import org.pepstock.jem.gwt.client.commons.Styles;

public class RegExValidatingTextBox
extends TextBox {
    private String validatingRegularExpression = null;
    private static final String PASTE_DISABLED_MESSAGE = "Paste disabled here!";
    private static final boolean DEFAULT_IS_PASTE_ENABLED = true;
    private boolean isPasteEnabled = true;
    private String errorTitle;
    private String okTitle;

    public RegExValidatingTextBox(String validatingRegularExpression, String errorTitle, boolean isPasteEnabled) {
        this.errorTitle = errorTitle;
        this.validatingRegularExpression = validatingRegularExpression;
        this.isPasteEnabled = isPasteEnabled;
        if (!isPasteEnabled) {
            super.sinkEvents(524288);
            this.errorTitle = this.errorTitle + " " + PASTE_DISABLED_MESSAGE;
            this.okTitle = PASTE_DISABLED_MESSAGE;
        }
        this.setErrorStyle();
        super.addKeyUpHandler((KeyUpHandler)new TextCheckHandler());
        super.addValueChangeHandler((ValueChangeHandler)new TextChangedCheckHandler());
    }

    public RegExValidatingTextBox(String validatingRegularExpression, String errorTitle) {
        this(errorTitle, validatingRegularExpression, true);
    }

    public RegExValidatingTextBox(String validatingRegularExpression) {
        this(validatingRegularExpression, null, true);
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        switch (event.getTypeInt()) {
            case 524288: {
                event.stopPropagation();
                event.preventDefault();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void setValidatingRegularExpression(String validatingRegularExpression) {
        this.validatingRegularExpression = validatingRegularExpression;
    }

    public boolean isValidText() {
        return this.getText().matches(this.validatingRegularExpression);
    }

    public boolean isValidValue() {
        return this.getValue().matches(this.validatingRegularExpression);
    }

    public void setText(String text) {
        super.setText(text);
        this.checkTextStyle();
    }

    public void setValue(String value) {
        super.setValue((Object)value);
        this.checkValueStyle();
    }

    private void checkTextStyle() {
        if (super.getText() != null && this.isValidText()) {
            this.setOkStyle();
        } else {
            this.setErrorStyle();
        }
    }

    private void checkValueStyle() {
        if (super.getValue() != null && this.isValidValue()) {
            this.setOkStyle();
        } else {
            this.setErrorStyle();
        }
    }

    public void setTitle(String value) {
        this.okTitle = this.isPasteEnabled ? value : value + PASTE_DISABLED_MESSAGE;
        this.checkTextStyle();
    }

    protected void setErrorStyle() {
        if (null != this.errorTitle) {
            super.setTitle(this.errorTitle);
        } else {
            super.setTitle(this.okTitle);
        }
        this.addStyleName(Styles.INSTANCE.textBox().mandatoryError());
    }

    protected void setOkStyle() {
        super.setTitle(this.okTitle);
        this.removeStyleName(Styles.INSTANCE.textBox().mandatoryError());
    }

    static {
        Styles.INSTANCE.textBox().ensureInjected();
    }

    private class TextChangedCheckHandler
    implements ValueChangeHandler<String> {
        private TextChangedCheckHandler() {
        }

        public void onValueChange(ValueChangeEvent<String> event) {
            RegExValidatingTextBox.this.checkTextStyle();
        }
    }

    private class TextCheckHandler
    implements KeyUpHandler {
        private TextCheckHandler() {
        }

        public void onKeyUp(KeyUpEvent event) {
            RegExValidatingTextBox.this.checkTextStyle();
        }
    }
}

