/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.HideHandler;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.PreferredButton;
import org.pepstock.jem.gwt.client.commons.Styles;

public abstract class MessageBox
extends PopupPanel {
    private HideHandler hideHandler = null;

    public MessageBox(ImageResource image, String title, String message) {
        super(false, true);
        this.setAnimationEnabled(true);
        this.setGlassEnabled(true);
        this.setStyleName(Styles.INSTANCE.messageBox().main());
        HTML msg = new HTML(message);
        msg.addStyleName(Styles.INSTANCE.messageBox().message());
        int maxWidth = Window.getClientWidth() * 75 / 100;
        this.getElement().getStyle().setPropertyPx("maxWidth", maxWidth);
        DockPanel dock = new DockPanel();
        dock.setSpacing(5);
        final HorizontalPanel flow = new HorizontalPanel();
        flow.setSpacing(4);
        if (this.getPreferredButtons() != null) {
            for (int i = 0; i < this.getPreferredButtons().length; ++i) {
                PreferredButton button = this.getPreferredButtons()[i];
                button.setMessageBox(this);
                flow.add((Widget)button);
            }
        }
        final int defaultButtonIndex = flow.getWidgetIndex((Widget)this.getDefaultButton());
        ((PreferredButton)flow.getWidget(defaultButtonIndex)).addStyleName(Styles.INSTANCE.common().defaultActionButton());
        dock.add((Widget)flow, DockPanel.SOUTH);
        dock.setCellHorizontalAlignment((Widget)flow, DockPanel.ALIGN_CENTER);
        if (title != null) {
            Label t = new Label(title);
            t.addStyleName(Styles.INSTANCE.messageBox().title());
            dock.add((Widget)t, DockPanel.NORTH);
            dock.setCellHorizontalAlignment((Widget)t, DockPanel.ALIGN_CENTER);
        }
        dock.add((Widget)msg, DockPanel.CENTER);
        dock.setCellVerticalAlignment((Widget)msg, DockPanel.ALIGN_MIDDLE);
        dock.add((Widget)new Image(image == null ? Images.INSTANCE.info() : image), DockPanel.WEST);
        dock.setWidth("100%");
        this.setWidget((Widget)dock);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                ((PreferredButton)flow.getWidget(defaultButtonIndex)).setFocus(true);
            }
        });
    }

    public abstract PreferredButton[] getPreferredButtons();

    public abstract PreferredButton getDefaultButton();

    public HideHandler getHideHandler() {
        return this.hideHandler;
    }

    public void setHideHandler(HideHandler hideHandler) {
        this.hideHandler = hideHandler;
    }

    public void open() {
        this.center();
    }

    static {
        Styles.INSTANCE.messageBox().ensureInjected();
    }
}

