/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.TextBox;
import org.pepstock.jem.gwt.client.commons.Styles;

public class MandatoryTextBox
extends TextBox {
    protected static final String TITLE = "Please fill out this field.";

    public MandatoryTextBox() {
        this.setMandatoryErrorStyle();
        super.addKeyUpHandler((KeyUpHandler)new TextCheckHandler());
    }

    public void setText(String text) {
        super.setText(text);
        if (text != null && !text.trim().isEmpty()) {
            this.setMandatoryOkStyle();
        } else {
            this.setMandatoryErrorStyle();
        }
    }

    public void setValue(String value) {
        super.setValue((Object)value);
        if (value != null && !value.trim().isEmpty()) {
            this.setMandatoryOkStyle();
        } else {
            this.setMandatoryErrorStyle();
        }
    }

    protected void setMandatoryErrorStyle() {
        this.addStyleName(Styles.INSTANCE.textBox().mandatoryError());
        this.setTitle(TITLE);
    }

    protected void setMandatoryOkStyle() {
        this.setTitle(null);
        this.removeStyleName(Styles.INSTANCE.textBox().mandatoryError());
    }

    public boolean isCompiled() {
        return !this.getText().trim().isEmpty();
    }

    static {
        Styles.INSTANCE.textBox().ensureInjected();
    }

    private class TextCheckHandler
    implements KeyUpHandler {
        private TextCheckHandler() {
        }

        public void onKeyUp(KeyUpEvent event) {
            if (!MandatoryTextBox.this.isCompiled()) {
                MandatoryTextBox.this.setMandatoryErrorStyle();
            } else {
                MandatoryTextBox.this.setMandatoryOkStyle();
            }
        }
    }
}

