/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import java.io.Serializable;
import java.util.Comparator;
import org.pepstock.jem.gwt.client.security.CurrentUser;

public abstract class IndexedColumnComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = "-";
    private static final int DEFAULT_INDEX = 1;
    private int index = 1;
    private boolean ascending = true;
    private String preferenceKey = null;

    public IndexedColumnComparator() {
        this(1);
    }

    public IndexedColumnComparator(int index) {
        this(index, null);
    }

    public IndexedColumnComparator(int index, String preferenceKey) {
        this.index = index;
        this.preferenceKey = preferenceKey;
        this.getPreferenceValues();
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        this.setPreferenceValues();
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
        this.setPreferenceValues();
    }

    private void getPreferenceValues() {
        String pref;
        if (this.preferenceKey != null && (pref = CurrentUser.getInstance().getStringPreference(this.preferenceKey)) != null) {
            String[] values = pref.split(SEPARATOR);
            this.index = Integer.valueOf(values[0]);
            this.ascending = Boolean.valueOf(values[1]);
        }
    }

    private void setPreferenceValues() {
        if (this.preferenceKey != null) {
            CurrentUser.getInstance().setStringPreference(this.preferenceKey, this.index + SEPARATOR + this.ascending);
        }
    }
}

