/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Image;
import org.pepstock.jem.gwt.client.commons.Styles;

public class ImageAndTextButton
extends Button {
    private static final String TEXT_LEFT_PADDING = " ";
    private String label;
    private TextPosition textPosition = TextPosition.RIGHT;

    public ImageAndTextButton(ImageResource icon, String label, TextPosition position) {
        this.textPosition = position;
        this.setText(label);
        this.setIcon(icon);
    }

    public void setIcon(ImageResource imageResource) {
        Image img = new Image(imageResource);
        img.addStyleName(Styles.INSTANCE.common().verticalAlignMiddle());
        DOM.insertBefore((Element)this.getElement(), (Element)img.getElement(), (Element)DOM.getFirstChild((Element)this.getElement()));
    }

    public void setText(String text) {
        Element textElement;
        this.label = text;
        switch (this.textPosition) {
            case RIGHT: {
                textElement = DOM.createElement((String)"span");
                textElement.setInnerText(TEXT_LEFT_PADDING + text);
                break;
            }
            case BOTTOM: {
                textElement = DOM.createElement((String)"div");
                textElement.setInnerText(text);
                break;
            }
            default: {
                throw new RuntimeException("Unable to know text position");
            }
        }
        textElement.addClassName(Styles.INSTANCE.common().verticalAlignMiddle());
        DOM.insertChild((Element)this.getElement(), (Element)textElement, (int)0);
    }

    public String getText() {
        return this.label;
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }

    public static enum TextPosition {
        RIGHT,
        BOTTOM;

    }
}

