/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.events.EventBus;
import org.pepstock.jem.gwt.client.events.FilterEvent;
import org.pepstock.jem.util.filters.FilterToken;

public class FilterInputPanel
extends PopupPanel {
    public static final int DEFAULT_DELAY = 1000;
    public static final int NO_DELAY = -1;
    private static Label description = new Label("ENTER = confirm; ESC = exit", false);
    private Timer timer = null;
    private int delay = 1000;
    private VerticalPanel popupContent = new VerticalPanel();
    private HorizontalPanel filterLine = new HorizontalPanel();
    private String filterName = null;
    private Label filterLabel = null;
    private TextBox filterValue = new TextBox();

    public FilterInputPanel(String filterToken) {
        this(filterToken, null);
    }

    public FilterInputPanel(String filterToken, final String helpPattern) {
        super(true, false);
        this.popupContent.setSpacing(1);
        this.popupContent.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.popupContent.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        this.filterName = filterToken;
        this.filterLine.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.filterLine.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.filterLine.setSpacing(5);
        this.filterLabel = new Label(filterToken + ":");
        this.filterLine.add((Widget)this.filterLabel);
        if (helpPattern != null && !helpPattern.trim().isEmpty()) {
            this.filterValue.setText(helpPattern);
        }
        this.filterLine.add((Widget)this.filterValue);
        this.filterValue.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                switch (event.getNativeKeyCode()) {
                    case 13: {
                        if (FilterInputPanel.this.filterValue.getText().trim().isEmpty() || FilterInputPanel.this.filterValue.getText().equalsIgnoreCase(helpPattern)) break;
                        FilterToken filterToken = new FilterToken(FilterInputPanel.this.filterName, FilterInputPanel.this.filterValue.getText());
                        FilterEvent filterEvent = new FilterEvent(filterToken);
                        EventBus.INSTANCE.fireEvent((GwtEvent)filterEvent);
                        FilterInputPanel.this.stopProcessing();
                        break;
                    }
                    case 27: {
                        FilterInputPanel.this.stopProcessing();
                        break;
                    }
                }
            }
        });
        this.popupContent.add((Widget)this.filterLine);
        this.popupContent.add((Widget)description);
        this.setWidget((Widget)this.popupContent);
    }

    public void setFocus() {
        this.filterValue.setFocus(true);
        int valueLength = this.filterValue.getText().length();
        if (valueLength > 0) {
            this.filterValue.setSelectionRange(0, valueLength);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void stopProcessing() {
        if (this.delay != -1 && this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.hide();
    }

    public void startProcessing() {
        if (this.delay != -1) {
            this.timer = new Timer(){

                public void run() {
                    FilterInputPanel.this.show();
                    FilterInputPanel.this.setFocus();
                }
            };
            this.timer.schedule(this.delay);
        } else {
            this.show();
            this.setFocus();
        }
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        description.addStyleName(Styles.INSTANCE.common().smallGreyDescription());
    }
}

