/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import java.util.Collection;

public class CSVUtil {
    public static final String COMMA_STRING = ",";
    public static final String COMMA_SPACE_STRING = ", ";
    public static final char COMMA_CHAR = ',';
    public static final String NULL = "null";

    private CSVUtil() {
    }

    public static String getCSVPhrase(Collection<?> objects) {
        return CSVUtil.getCSVPhrase(objects, ',');
    }

    public static String getCSVPhrase(Collection<?> objects, char separator) {
        return CSVUtil.getCSVPhrase(objects, String.valueOf(separator));
    }

    public static String getCSVPhrase(Collection<?> objects, String separator) {
        StringBuffer s = new StringBuffer();
        if (!objects.isEmpty()) {
            for (Object o : objects) {
                if (o != null) {
                    s.append(o.toString());
                } else {
                    s.append(NULL);
                }
                s.append(separator);
            }
            s.setLength(s.length() - separator.length());
        }
        return s.toString();
    }

    public static String getCSVPhrase(Object[] objects) {
        return CSVUtil.getCSVPhrase(objects, ',');
    }

    public static String getCSVPhrase(Object[] objects, char separator) {
        return CSVUtil.getCSVPhrase(objects, String.valueOf(separator));
    }

    public static String getCSVPhrase(Object[] objects, String separator) {
        StringBuffer s = new StringBuffer();
        if (objects.length > 0) {
            for (Object o : objects) {
                if (o != null) {
                    s.append(o.toString());
                } else {
                    s.append(NULL);
                }
                s.append(separator);
            }
            s.setLength(s.length() - separator.length());
        }
        return s.toString();
    }

    public static String[] split(String CSVPhrase) {
        return CSVUtil.split(CSVPhrase, COMMA_STRING);
    }

    public static String[] split(String CSVPhrase, char separator) {
        return CSVUtil.split(CSVPhrase, new Character(separator).toString());
    }

    public static String[] split(String CSVPhrase, String separator) {
        return CSVPhrase.split(separator);
    }

    public static String[] splitAndTrim(String CSVPhrase) {
        String[] toReturn = CSVUtil.split(CSVPhrase);
        CSVUtil.trim(toReturn);
        return toReturn;
    }

    public static String[] splitAndTrim(String CSVPhrase, char separator) {
        String[] toReturn = CSVUtil.split(CSVPhrase, separator);
        CSVUtil.trim(toReturn);
        return toReturn;
    }

    public static String[] splitAndTrim(String CSVPhrase, String separator) {
        String[] toReturn = CSVUtil.split(CSVPhrase, separator);
        CSVUtil.trim(toReturn);
        return toReturn;
    }

    public static void trim(String[] strings) {
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = strings[i].trim();
            }
        }
    }
}

