/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.pepstock.jem.gwt.client.commons.DefaultTablePagerResources;
import org.pepstock.jem.gwt.client.commons.DefaultTableStyle;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.commons.InspectListener;

public abstract class AbstractTable<T> {
    public static final int DEFAULT_PAGE_SIZE = 25;
    private final List<T> EMPTY = new ArrayList<T>();
    private CellTable<T> table = null;
    private SimplePager pager = null;
    private Collection<T> dataProvider = this.EMPTY;
    private AsyncDataProvider<T> provider = null;
    private MultiSelectionModel<T> selectionModel = null;
    private InspectListener<T> inspectListener = null;
    private boolean hasFilterableHeader = false;

    public AbstractTable() {
        this((CellTable.Resources)GWT.create(DefaultTableStyle.class), (SimplePager.Resources)GWT.create(DefaultTablePagerResources.Resources.class), 25);
    }

    public AbstractTable(boolean filterableHeaders) {
        this((CellTable.Resources)GWT.create(DefaultTableStyle.class), (SimplePager.Resources)GWT.create(DefaultTablePagerResources.Resources.class), 25, filterableHeaders);
    }

    public AbstractTable(CellTable.Resources resources, SimplePager.Resources pagerResources) {
        this(resources, pagerResources, 25);
    }

    public AbstractTable(int pageSize) {
        this((CellTable.Resources)GWT.create(DefaultTableStyle.class), (SimplePager.Resources)GWT.create(DefaultTablePagerResources.Resources.class), pageSize);
    }

    public AbstractTable(CellTable.Resources resources, int pageSize) {
        this(resources, (SimplePager.Resources)GWT.create(DefaultTablePagerResources.Resources.class), pageSize);
    }

    public AbstractTable(CellTable.Resources resources, SimplePager.Resources pagerResources, int pageSize) {
        this(resources, pagerResources, pageSize, false);
    }

    protected AbstractTable(CellTable.Resources resources, SimplePager.Resources pagerResources, final int pageSize, boolean filterableHeaders) {
        this.table = resources != null ? new CellTable(pageSize, resources) : new CellTable();
        this.hasFilterableHeader = filterableHeaders;
        this.table.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED);
        this.table.setPageSize(pageSize);
        this.table.setWidth("100%");
        this.table.setHeight("100%");
        this.pager = new SimplePager(SimplePager.TextLocation.CENTER, pagerResources, false, 0, true);
        this.pager.addStyleName(DefaultTablePagerResources.INSTANCE.styles().background());
        this.selectionModel = new MultiSelectionModel();
        this.table.setSelectionModel(this.selectionModel, (CellPreviewEvent.Handler)DefaultSelectionEventManager.createCheckboxManager((int)0));
        ColumnSortEvent.AsyncHandler columnSortHandler = new ColumnSortEvent.AsyncHandler(this.table);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)columnSortHandler);
        final IndexedColumnComparator<T> comparator = this.initCellTable(this.table);
        this.provider = new AsyncDataProvider<T>(){

            public void onRangeChanged(HasData<T> tb) {
                int start = 0;
                start = AbstractTable.this.pager.getPage() <= 0 ? 0 : AbstractTable.this.pager.getPage() * pageSize;
                int end = start + pageSize;
                end = end >= AbstractTable.this.dataProvider.size() ? AbstractTable.this.dataProvider.size() : end;
                ArrayList list = new ArrayList(AbstractTable.this.dataProvider);
                ColumnSortList sortList = AbstractTable.this.table.getColumnSortList();
                if (sortList != null) {
                    if (sortList.size() > 0) {
                        ColumnSortList.ColumnSortInfo info = sortList.get(0);
                        Column c = info.getColumn();
                        int index = AbstractTable.this.table.getColumnIndex(c);
                        comparator.setIndex(index);
                        comparator.setAscending(info.isAscending());
                    } else {
                        Column c = AbstractTable.this.table.getColumn(comparator.getIndex());
                        ColumnSortList.ColumnSortInfo sortInfo = new ColumnSortList.ColumnSortInfo(c, comparator.isAscending());
                        sortList.push(sortInfo);
                    }
                    Collections.sort(list, comparator);
                }
                List mix = list.subList(start, end);
                AbstractTable.this.table.setRowData(start, mix);
                this.updateRowData(start, mix);
                AbstractTable.this.table.setVisibleRange(start, pageSize);
                if (pageSize == Integer.MAX_VALUE) {
                    AbstractTable.this.pager.setVisible(false);
                }
            }

            public void updateRowCount(int size, boolean exact) {
                super.updateRowCount(size, exact);
                Range range = AbstractTable.this.table.getVisibleRange();
                AbstractTable.this.table.setVisibleRange(0, range.getLength());
                this.onRangeChanged((HasData)AbstractTable.this.table);
            }
        };
        this.provider.addDataDisplay(this.table);
        this.provider.updateRowCount(this.dataProvider.size(), true);
        this.pager.setDisplay(this.table);
        this.pager.setPageSize(pageSize);
        this.setRowData(null);
    }

    public InspectListener<T> getInspectListener() {
        return this.inspectListener;
    }

    public void setInspectListener(InspectListener<T> listener) {
        this.inspectListener = listener;
    }

    public CellTable<T> getTable() {
        return this.table;
    }

    public SimplePager getPager() {
        return this.pager;
    }

    public boolean hasFilterableHeaders() {
        return this.hasFilterableHeader;
    }

    public void setRowData(Collection<T> collection) {
        this.dataProvider = collection != null ? (!collection.isEmpty() ? collection : this.EMPTY) : this.EMPTY;
        this.provider.updateRowCount(this.dataProvider.size(), true);
    }

    public abstract IndexedColumnComparator<T> initCellTable(CellTable<T> var1);

    static {
        DefaultTablePagerResources.INSTANCE.styles().ensureInjected();
    }
}

