/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ImageAndTextButton;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.SharedObjects;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.TimeDisplayUtils;
import org.pepstock.jem.gwt.client.commons.UITools;
import org.pepstock.jem.gwt.client.security.CurrentUser;
import org.pepstock.jem.gwt.client.security.LoggedUser;
import org.pepstock.jem.gwt.client.services.Services;

public class SmallHeader
extends Grid {
    protected static final int ENV_BOX_UPDATE_INTERVAL = 60000;

    public SmallHeader() {
        super(1, 3);
        this.setWidth("100%");
        this.addStyleName(Styles.INSTANCE.common().noWrap());
        this.getColumnFormatter().setWidth(1, "50%");
        this.getColumnFormatter().setWidth(2, "50%");
        this.getRowFormatter().setVerticalAlign(0, HasVerticalAlignment.ALIGN_MIDDLE);
        Image logoImage = new Image(Images.INSTANCE.logoSmall());
        this.setWidget(0, 0, (Widget)logoImage);
        final FlexTable environmentInfoBox = new FlexTable();
        environmentInfoBox.addStyleName(Styles.INSTANCE.header().infoBox());
        HTMLTable.ColumnFormatter eibColumnFormatter = environmentInfoBox.getColumnFormatter();
        eibColumnFormatter.setWidth(0, "25%");
        eibColumnFormatter.setWidth(1, "25%");
        eibColumnFormatter.setWidth(2, "25%");
        eibColumnFormatter.setWidth(3, "25%");
        FlexTable.FlexCellFormatter eibCellFormatter = environmentInfoBox.getFlexCellFormatter();
        eibCellFormatter.setColSpan(0, 0, 4);
        environmentInfoBox.setText(0, 0, "JEM environment overview: ");
        eibCellFormatter.addStyleName(0, 0, Styles.INSTANCE.header().infoBoxHeader());
        environmentInfoBox.setText(1, 0, "Name");
        environmentInfoBox.setText(1, 2, "Nodes (web)");
        environmentInfoBox.setText(2, 0, "Jobs in execution");
        environmentInfoBox.setText(2, 2, "Uptime");
        UITools.setColumnKeyValueStyle(environmentInfoBox, Styles.INSTANCE.common().bold(), true);
        this.setWidget(0, 1, (Widget)environmentInfoBox);
        environmentInfoBox.setText(1, 1, "(updating)");
        environmentInfoBox.setText(1, 3, "(updating)");
        environmentInfoBox.setText(2, 1, "(updating)");
        environmentInfoBox.setText(2, 3, "(updating)");
        Timer envBoxUpdateTimer = new Timer(){

            public void run() {
                environmentInfoBox.setText(1, 1, "(updating)");
                environmentInfoBox.setText(1, 3, "(updating)");
                environmentInfoBox.setText(2, 1, "(updating)");
                environmentInfoBox.setText(2, 3, "(updating)");
                final long start = System.currentTimeMillis();
                Services.INFO_SERVICE.getEnvironmentInformation((AsyncCallback<String[]>)new ServiceAsyncCallback<String[]>(){

                    @Override
                    public void onJemSuccess(String[] result) {
                        environmentInfoBox.setText(1, 1, result[0]);
                        environmentInfoBox.setText(1, 3, result[1]);
                        environmentInfoBox.setText(2, 1, result[2]);
                        try {
                            long elapsed = System.currentTimeMillis() - start;
                            SharedObjects.setClusterDifferenceTime(System.currentTimeMillis() - Long.parseLong(result[4]) - elapsed);
                            SharedObjects.setExecutionEnvironment(result[0]);
                            Long uptime = Long.parseLong(result[3]);
                            String readableUptime = TimeDisplayUtils.getReadableTimeDiff(uptime, 1);
                            environmentInfoBox.setText(2, 3, readableUptime);
                        }
                        catch (Exception e) {
                            environmentInfoBox.setText(2, 3, "(unavailable)");
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        environmentInfoBox.setText(1, 1, "(unavailable)");
                        environmentInfoBox.setText(1, 3, "(unavailable)");
                        environmentInfoBox.setText(2, 1, "(unavailable)");
                        environmentInfoBox.setText(2, 3, "(unavailable)");
                    }

                    @Override
                    public void onJemExecuted() {
                    }
                });
            }
        };
        envBoxUpdateTimer.run();
        envBoxUpdateTimer.scheduleRepeating(60000);
        FlexTable userInfoBox = new FlexTable();
        userInfoBox.addStyleName(Styles.INSTANCE.header().infoBox());
        HTMLTable.ColumnFormatter uibColumnFormatter = userInfoBox.getColumnFormatter();
        uibColumnFormatter.setWidth(0, "25%");
        uibColumnFormatter.setWidth(1, "25%");
        uibColumnFormatter.setWidth(2, "25%");
        uibColumnFormatter.setWidth(3, "25%");
        FlexTable.FlexCellFormatter uibCellFormatter = userInfoBox.getFlexCellFormatter();
        uibCellFormatter.setColSpan(0, 0, 5);
        uibCellFormatter.setRowSpan(0, 4, 3);
        uibCellFormatter.setAlignment(0, 4, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        userInfoBox.setText(0, 0, "User information: ");
        uibCellFormatter.addStyleName(0, 0, Styles.INSTANCE.header().infoBoxHeader());
        LoggedUser user = CurrentUser.getInstance().getUser();
        userInfoBox.setText(1, 0, "ID");
        uibCellFormatter.addStyleName(1, 0, Styles.INSTANCE.common().bold());
        userInfoBox.setText(1, 1, user.getId());
        userInfoBox.setText(1, 2, "Org. Unit ID");
        uibCellFormatter.addStyleName(1, 2, Styles.INSTANCE.common().bold());
        userInfoBox.setText(2, 2, "Org. Unit Name");
        uibCellFormatter.addStyleName(2, 2, Styles.INSTANCE.common().bold());
        userInfoBox.setText(2, 0, "Name");
        uibCellFormatter.addStyleName(2, 0, Styles.INSTANCE.common().bold());
        userInfoBox.setText(2, 1, user.getName());
        String orgUnitId = "(none)";
        String orgUnitName = "(none)";
        if (user.getOrganizationalUnit() != null) {
            if (user.getOrganizationalUnit().getId() != null && !user.getOrganizationalUnit().getId().isEmpty()) {
                orgUnitId = user.getOrganizationalUnit().getId();
            }
            if (user.getOrganizationalUnit().getName() != null && !user.getOrganizationalUnit().getName().isEmpty()) {
                orgUnitName = user.getOrganizationalUnit().getName();
            }
        }
        userInfoBox.setText(1, 3, orgUnitId);
        userInfoBox.setText(2, 3, orgUnitName);
        final ImageAndTextButton btnLogout = new ImageAndTextButton(Images.INSTANCE.powerOff32(), "Logoff", ImageAndTextButton.TextPosition.BOTTOM);
        btnLogout.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                btnLogout.setEnabled(false);
                Services.LOGIN_MANAGER.logoff(CurrentUser.getInstance().getUser().getPreferences(), (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Logoff error!", caught.getMessage());
                        alert.open();
                        btnLogout.setEnabled(true);
                    }

                    @Override
                    public void onJemSuccess(Boolean result) {
                        CurrentUser.getInstance().setUser(null);
                        Window.Location.reload();
                    }

                    @Override
                    public void onJemExecuted() {
                    }
                });
            }
        });
        userInfoBox.setWidget(0, 4, (Widget)btnLogout);
        this.setWidget(0, 2, (Widget)userInfoBox);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.header().ensureInjected();
    }
}

