/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.validator;

import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.validator.ValidationException;
import org.springframework.batch.item.validator.Validator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingItemProcessor<T>
implements ItemProcessor<T, T> {
    private Validator<? super T> validator;
    private boolean filter = false;

    public ValidatingItemProcessor(Validator<? super T> validator) {
        Assert.notNull(validator, (String)"Validator must not be null.");
        this.validator = validator;
    }

    public void setValidator(Validator<? super T> validator) {
        this.validator = validator;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    @Override
    public T process(T item) throws ValidationException {
        try {
            this.validator.validate(item);
        }
        catch (ValidationException e) {
            if (this.filter) {
                return null;
            }
            throw e;
        }
        return item;
    }
}

