/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.jms;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.jms.core.JmsOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsItemWriter<T>
implements ItemWriter<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private JmsOperations jmsTemplate;

    public void setJmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        for (T item : items) {
            this.jmsTemplate.convertAndSend(item);
        }
    }
}

