/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.jms;

import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.jms.core.JmsOperations;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsItemReader<T>
implements ItemReader<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected Class<? extends T> itemType;
    protected JmsOperations jmsTemplate;

    public void setJmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setItemType(Class<? extends T> itemType) {
        this.itemType = itemType;
    }

    @Override
    public T read() {
        if (this.itemType != null && this.itemType.isAssignableFrom(Message.class)) {
            return (T)this.jmsTemplate.receive();
        }
        Object result = this.jmsTemplate.receiveAndConvert();
        if (this.itemType != null && result != null) {
            Assert.state((boolean)this.itemType.isAssignableFrom(result.getClass()), (String)("Received message payload of wrong type: expected [" + this.itemType + "]"));
        }
        return (T)result;
    }
}

