/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.Db2PagingQueryProvider;
import org.springframework.batch.item.database.support.DerbyPagingQueryProvider;
import org.springframework.batch.item.database.support.HsqlPagingQueryProvider;
import org.springframework.batch.item.database.support.MySqlPagingQueryProvider;
import org.springframework.batch.item.database.support.OraclePagingQueryProvider;
import org.springframework.batch.item.database.support.PostgresPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlServerPagingQueryProvider;
import org.springframework.batch.item.database.support.SybasePagingQueryProvider;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlPagingQueryProviderFactoryBean
implements FactoryBean {
    private DataSource dataSource;
    private String databaseType;
    private String fromClause;
    private String whereClause;
    private String selectClause;
    private String sortKey;
    private boolean ascending = true;
    private Map<DatabaseType, AbstractSqlPagingQueryProvider> providers = new HashMap<DatabaseType, AbstractSqlPagingQueryProvider>();

    public SqlPagingQueryProviderFactoryBean() {
        this.providers.put(DatabaseType.DB2, new Db2PagingQueryProvider());
        this.providers.put(DatabaseType.DB2ZOS, new Db2PagingQueryProvider());
        this.providers.put(DatabaseType.DERBY, new DerbyPagingQueryProvider());
        this.providers.put(DatabaseType.HSQL, new HsqlPagingQueryProvider());
        this.providers.put(DatabaseType.MYSQL, new MySqlPagingQueryProvider());
        this.providers.put(DatabaseType.ORACLE, new OraclePagingQueryProvider());
        this.providers.put(DatabaseType.POSTGRES, new PostgresPagingQueryProvider());
        this.providers.put(DatabaseType.SQLSERVER, new SqlServerPagingQueryProvider());
        this.providers.put(DatabaseType.SYBASE, new SybasePagingQueryProvider());
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = fromClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public void setSelectClause(String selectClause) {
        this.selectClause = selectClause;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public Object getObject() throws Exception {
        DatabaseType type;
        try {
            type = this.databaseType != null ? DatabaseType.valueOf(this.databaseType.toUpperCase()) : DatabaseType.fromMetaData(this.dataSource);
        }
        catch (MetaDataAccessException e) {
            throw new IllegalArgumentException("Could not inspect meta data for database type.  You have to supply it explicitly.");
        }
        AbstractSqlPagingQueryProvider provider = this.providers.get((Object)type);
        Assert.state((provider != null ? 1 : 0) != 0, (String)("Should not happen: missing PagingQueryProvider for DatabaseType=" + (Object)((Object)type)));
        provider.setFromClause(this.fromClause);
        provider.setWhereClause(this.whereClause);
        provider.setSortKey(this.sortKey);
        provider.setAscending(this.ascending);
        if (StringUtils.hasText((String)this.selectClause)) {
            provider.setSelectClause(this.selectClause);
        }
        provider.init(this.dataSource);
        return provider;
    }

    public Class<PagingQueryProvider> getObjectType() {
        return PagingQueryProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

